/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

public class IncrementalFiler
implements Filer {
    private final Filer delegate;
    private IncrementalProcessingStrategy strategy;

    IncrementalFiler(Filer delegate, IncrementalProcessingStrategy strategy) {
        this.delegate = delegate;
        this.setStrategy(strategy);
    }

    public void setStrategy(IncrementalProcessingStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy");
        }
        this.strategy = strategy;
    }

    @Override
    public final JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.strategy.recordGeneratedType(name, originatingElements);
        return this.delegate.createSourceFile(name, originatingElements);
    }

    @Override
    public final JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.strategy.recordGeneratedType(name, originatingElements);
        return this.delegate.createClassFile(name, originatingElements);
    }

    @Override
    public final FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        this.strategy.recordGeneratedResource(location, pkg, relativeName, originatingElements);
        return this.delegate.createResource(location, pkg, relativeName, originatingElements);
    }

    @Override
    public final FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        this.strategy.recordAccessedResource(location, pkg, relativeName);
        return this.delegate.getResource(location, pkg, relativeName);
    }
}

