/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dependencies.ModuleDependencyCapabilitiesInternal;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultMutableModuleDependencyCapabilitiesHandler
implements ModuleDependencyCapabilitiesInternal {
    private final NotationParser<Object, Capability> notationParser;
    private final Set<Capability> requestedCapabilities = Sets.newLinkedHashSet();

    public DefaultMutableModuleDependencyCapabilitiesHandler(NotationParser<Object, Capability> notationParser) {
        this.notationParser = notationParser;
    }

    public void requireCapability(Object capabilityNotation) {
        this.requestedCapabilities.add((Capability)this.notationParser.parseNotation(capabilityNotation));
    }

    public void requireCapabilities(Object ... capabilityNotations) {
        for (Object notation : capabilityNotations) {
            this.requireCapability(notation);
        }
    }

    @Override
    public List<Capability> getRequestedCapabilities() {
        return ImmutableList.copyOf(this.requestedCapabilities);
    }
}

