/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.simpleframework.util.parse.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListParser<T>
extends Parser {
    private PriorityQueue<Entry> order = new PriorityQueue();
    private List<T> list = new ArrayList<T>();
    private char[] text = new char[0];
    private long qvalue;
    private int pos;
    private boolean build;

    public ListParser() {
    }

    public ListParser(String text) {
        this();
        this.parse(text);
    }

    public ListParser(List<String> list) {
        this();
        this.parse(list);
    }

    public void parse(List<String> list) {
        for (String value : list) {
            this.parse(value);
            this.build = true;
        }
        this.build = false;
    }

    public List<T> list() {
        return this.list;
    }

    private void build() {
        while (!this.order.isEmpty()) {
            Entry entry = (Entry)this.order.remove();
            Object value = entry.getValue();
            this.list.add(value);
        }
    }

    @Override
    protected void parse() {
        while (this.off < this.count) {
            this.clear();
            this.value();
            this.save();
        }
        this.build();
    }

    @Override
    protected void init() {
        if (this.text.length < this.count) {
            this.text = new char[this.count];
        }
        if (!this.build) {
            this.list.clear();
        }
        this.off = 0;
        this.pos = 0;
        this.order.clear();
    }

    private void clear() {
        this.qvalue = Long.MAX_VALUE;
        this.pos = 0;
    }

    private void value() {
        block0: while (this.off < this.count) {
            if (this.buf[this.off++] == '\"') {
                this.text[this.pos++] = this.buf[this.off - 1];
                while (++this.off < this.count && (this.buf[this.off - 1] != '\"' || this.buf[this.off - 2] == '\\')) {
                    this.text[this.pos++] = this.buf[this.off - 1];
                }
            } else if (this.buf[this.off - 1] == ';') {
                int seek = this.off;
                while (seek + 1 < this.count) {
                    if (!this.space(this.buf[seek])) {
                        if (this.buf[seek] == 'q' && this.buf[seek + 1] == '=') {
                            this.off = seek;
                            this.qvalue();
                            continue block0;
                        }
                        break;
                    }
                    ++seek;
                }
            }
            if (this.buf[this.off - 1] == ',') break;
            this.text[this.pos++] = this.buf[this.off - 1];
        }
    }

    private void save() {
        T value;
        int size;
        int start = 0;
        for (size = this.pos; size > 0 && this.space(this.text[size - 1]); --size) {
        }
        while (start < this.pos && this.space(this.text[start])) {
            ++start;
            --size;
        }
        if (size > 0 && (value = this.create(this.text, start, size)) != null) {
            this.save(value);
        }
    }

    private void save(T value) {
        int size = this.order.size();
        if (this.qvalue > 0L) {
            this.order.offer(new Entry(value, this.qvalue, size));
        }
    }

    private void qvalue() {
        if (this.skip("q=")) {
            char digit = '\u0000';
            this.qvalue = 0L;
            while (this.off < this.count) {
                if (this.buf[this.off] == '.') {
                    ++this.off;
                    continue;
                }
                if (!this.digit(this.buf[this.off])) break;
                digit = this.buf[this.off];
                digit = (char)(digit - 48);
                this.qvalue |= (long)digit;
                this.qvalue <<= 4;
                ++this.off;
            }
        }
    }

    protected abstract T create(char[] var1, int var2, int var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Comparable<Entry> {
        private final T value;
        private final long priority;
        private final int order;

        public Entry(T value, long priority, int order) {
            this.priority = priority;
            this.order = order;
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Entry entry) {
            long value = entry.priority - this.priority;
            if (value > 0L) {
                return 1;
            }
            if (value < 0L) {
                return -1;
            }
            return this.order - entry.order;
        }
    }
}

