/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import com.google.common.base.Objects;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

class IvyPatternMatcherExcludeRuleSpec
extends AbstractModuleExclusion {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName ivyArtifactName;
    private final PatternMatcher matcher;
    private final boolean isArtifactExclude;

    IvyPatternMatcherExcludeRuleSpec(ExcludeMetadata rule) {
        this.moduleId = rule.getModuleId();
        this.ivyArtifactName = rule.getArtifact();
        this.matcher = PatternMatchers.getInstance().getMatcher(rule.getMatcher());
        this.isArtifactExclude = this.ivyArtifactName != null;
    }

    public String toString() {
        return "{exclude-rule " + this.moduleId + ":" + this.ivyArtifactName + " with matcher " + this.matcher.getName() + "}";
    }

    @Override
    protected boolean doEquals(Object o) {
        IvyPatternMatcherExcludeRuleSpec other = (IvyPatternMatcherExcludeRuleSpec)o;
        return this.doExcludesSameModulesAs(other);
    }

    @Override
    protected int doHashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleId, this.ivyArtifactName});
    }

    @Override
    protected boolean doExcludesSameModulesAs(AbstractModuleExclusion other) {
        IvyPatternMatcherExcludeRuleSpec otherSpec = (IvyPatternMatcherExcludeRuleSpec)other;
        return this.moduleId.equals(otherSpec.moduleId) && Objects.equal((Object)this.ivyArtifactName, (Object)otherSpec.ivyArtifactName) && this.matcher.getName().equals(otherSpec.matcher.getName());
    }

    @Override
    protected boolean excludesNoModules() {
        return this.isArtifactExclude;
    }

    @Override
    public boolean excludeModule(ModuleIdentifier module) {
        if (this.isArtifactExclude) {
            return false;
        }
        return this.matches(this.moduleId.getGroup(), module.getGroup()) && this.matches(this.moduleId.getName(), module.getName());
    }

    @Override
    public boolean excludeArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        if (!this.isArtifactExclude) {
            return false;
        }
        return this.matches(this.moduleId.getGroup(), module.getGroup()) && this.matches(this.moduleId.getName(), module.getName()) && this.matches(this.ivyArtifactName.getName(), artifact.getName()) && this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) && this.matches(this.ivyArtifactName.getType(), artifact.getType());
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return this.isArtifactExclude;
    }

    private boolean matches(String expression, String input) {
        return this.matcher.getMatcher(expression).matches(input);
    }
}

