/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.transform.AbstractTransformer;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.DefaultTransformOutputs;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.properties.DefaultParameterValidationContext;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.reflect.InjectionPointQualifier;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.model.internal.type.ModelType;

public class DefaultTransformer
extends AbstractTransformer<TransformAction> {
    private final TransformParameters parameterObject;
    private final Class<? extends FileNormalizer> fileNormalizer;
    private final Class<? extends FileNormalizer> dependenciesNormalizer;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final IsolatableFactory isolatableFactory;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionFactory fileCollectionFactory;
    private final PropertyWalker parameterPropertyWalker;
    private final boolean requiresDependencies;
    private final InstanceFactory<? extends TransformAction> instanceFactory;
    private final boolean cacheable;
    private IsolatedParameters isolatedParameters;

    public DefaultTransformer(Class<? extends TransformAction> implementationClass, @Nullable TransformParameters parameterObject, ImmutableAttributes fromAttributes, Class<? extends FileNormalizer> inputArtifactNormalizer, Class<? extends FileNormalizer> dependenciesNormalizer, boolean cacheable, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, IsolatableFactory isolatableFactory, ValueSnapshotter valueSnapshotter, FileCollectionFactory fileCollectionFactory, PropertyWalker parameterPropertyWalker, InstantiationScheme actionInstantiationScheme) {
        super(implementationClass, fromAttributes);
        this.parameterObject = parameterObject;
        this.fileNormalizer = inputArtifactNormalizer;
        this.dependenciesNormalizer = dependenciesNormalizer;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.isolatableFactory = isolatableFactory;
        this.valueSnapshotter = valueSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.parameterPropertyWalker = parameterPropertyWalker;
        this.instanceFactory = actionInstantiationScheme.forType(implementationClass);
        this.requiresDependencies = this.instanceFactory.serviceInjectionTriggeredByAnnotation(InputArtifactDependencies.class);
        this.cacheable = cacheable;
    }

    public static void validateInputFileNormalizer(String propertyName, @Nullable Class<? extends FileNormalizer> normalizer, boolean cacheable, ParameterValidationContext parameterValidationContext) {
        if (cacheable) {
            if (normalizer == AbsolutePathInputNormalizer.class) {
                parameterValidationContext.visitError(null, propertyName, "is declared to be sensitive to absolute paths. This is not allowed for cacheable transforms");
            }
            if (normalizer == null) {
                parameterValidationContext.visitError(null, propertyName, "is declared without path sensitivity. Properties of cacheable transforms must declare their path sensitivity");
            }
        }
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactNormalizer() {
        return this.fileNormalizer;
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactDependenciesNormalizer() {
        return this.dependenciesNormalizer;
    }

    @Override
    public boolean isIsolated() {
        return this.isolatedParameters != null;
    }

    @Override
    public boolean requiresDependencies() {
        return this.requiresDependencies;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return this.getIsolatedParameters().getSecondaryInputsHash();
    }

    @Override
    public ImmutableList<File> transform(File inputArtifact, File outputDir, ArtifactTransformDependencies dependencies) {
        TransformAction transformAction = this.newTransformAction(inputArtifact, dependencies);
        DefaultTransformOutputs transformOutputs = new DefaultTransformOutputs(inputArtifact, outputDir);
        transformAction.transform((TransformOutputs)transformOutputs);
        return transformOutputs.getRegisteredOutputs();
    }

    public void visitDependencies(final TaskDependencyResolveContext context) {
        if (this.parameterObject != null) {
            this.parameterPropertyWalker.visitProperties((Object)this.parameterObject, ParameterValidationContext.NOOP, (PropertyVisitor)new PropertyVisitor.Adapter(){

                public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                    Object unpacked = value.call();
                    if (unpacked != null) {
                        context.maybeAdd(unpacked);
                    }
                }
            });
        }
    }

    @Override
    public void isolateParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        try {
            this.isolatedParameters = this.doIsolateParameters(fingerprinterRegistry);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(String.format("Cannot isolate parameters %s of artifact transform %s", this.parameterObject, ModelType.of(this.getImplementationClass()).getDisplayName()), (Throwable)e);
        }
    }

    protected IsolatedParameters doIsolateParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        Isolatable isolatedParameterObject = this.isolatableFactory.isolate((Object)this.parameterObject);
        Hasher hasher = Hashing.newHasher();
        DefaultTransformer.appendActionImplementation(this.getImplementationClass(), hasher, this.classLoaderHierarchyHasher);
        if (this.parameterObject != null) {
            DefaultTransformer.fingerprintParameters(this.valueSnapshotter, fingerprinterRegistry, this.fileCollectionFactory, this.parameterPropertyWalker, hasher, isolatedParameterObject.isolate(), this.cacheable);
        }
        HashCode secondaryInputsHash = hasher.hash();
        return new IsolatedParameters((Isolatable<? extends TransformParameters>)isolatedParameterObject, secondaryInputsHash);
    }

    private static void fingerprintParameters(final ValueSnapshotter valueSnapshotter, final FileCollectionFingerprinterRegistry fingerprinterRegistry, final FileCollectionFactory fileCollectionFactory, PropertyWalker propertyWalker, Hasher hasher, final Object parameterObject, final boolean cacheable) {
        final ImmutableSortedMap.Builder inputParameterFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
        final ImmutableSortedMap.Builder inputFileParameterFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
        ArrayList validationMessages = new ArrayList();
        final DefaultParameterValidationContext validationContext = new DefaultParameterValidationContext(validationMessages);
        propertyWalker.visitProperties(parameterObject, (ParameterValidationContext)validationContext, (PropertyVisitor)new PropertyVisitor.Adapter(){

            public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
                try {
                    Object preparedValue = InputParameterUtils.prepareInputParameterValue((Object)value);
                    if (preparedValue == null && !optional) {
                        validationContext.visitError(null, propertyName, "does not have a value specified");
                    }
                    inputParameterFingerprintsBuilder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(preparedValue));
                }
                catch (Throwable e) {
                    throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, DefaultTransformer.getParameterObjectDisplayName(parameterObject)), e);
                }
            }

            public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
                validationContext.visitError(null, propertyName, "is annotated with an output annotation");
            }

            public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                DefaultTransformer.validateInputFileNormalizer(propertyName, fileNormalizer, cacheable, (ParameterValidationContext)validationContext);
                FileCollectionFingerprinter fingerprinter = fingerprinterRegistry.getFingerprinter(FileParameterUtils.normalizerOrDefault(fileNormalizer));
                FileCollection inputFileValue = FileParameterUtils.resolveInputFileValue((FileCollectionFactory)fileCollectionFactory, (InputFilePropertyType)filePropertyType, (Object)value);
                CurrentFileCollectionFingerprint fingerprint = fingerprinter.fingerprint(inputFileValue);
                inputFileParameterFingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
            }
        });
        if (!validationMessages.isEmpty()) {
            throw new DefaultMultiCauseException(String.format(validationMessages.size() == 1 ? "A problem was found with the configuration of the artifact transform parameter %s." : "Some problems were found with the configuration of the artifact transform parameter %s.", DefaultTransformer.getParameterObjectDisplayName(parameterObject)), (Iterable)validationMessages.stream().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
        for (Map.Entry entry : inputParameterFingerprintsBuilder.build().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
        for (Map.Entry entry : inputFileParameterFingerprintsBuilder.build().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putHash(((CurrentFileCollectionFingerprint)entry.getValue()).getHash());
        }
    }

    private static String getParameterObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private TransformAction newTransformAction(File inputFile, ArtifactTransformDependencies artifactTransformDependencies) {
        TransformServiceLookup services = new TransformServiceLookup(inputFile, (TransformParameters)this.getIsolatedParameters().getIsolatedParameterObject().isolate(), this.requiresDependencies ? artifactTransformDependencies : null);
        return (TransformAction)this.instanceFactory.newInstance((ServiceLookup)services, new Object[0]);
    }

    private IsolatedParameters getIsolatedParameters() {
        if (this.isolatedParameters == null) {
            throw new IllegalStateException("The parameters of " + this.getDisplayName() + "need to be isolated first!");
        }
        return this.isolatedParameters;
    }

    private static class IsolatedParameters {
        private final HashCode secondaryInputsHash;
        private final Isolatable<? extends TransformParameters> isolatedParameterObject;

        public IsolatedParameters(Isolatable<? extends TransformParameters> isolatedParameterObject, HashCode secondaryInputsHash) {
            this.secondaryInputsHash = secondaryInputsHash;
            this.isolatedParameterObject = isolatedParameterObject;
        }

        public HashCode getSecondaryInputsHash() {
            return this.secondaryInputsHash;
        }

        public Isolatable<? extends TransformParameters> getIsolatedParameterObject() {
            return this.isolatedParameterObject;
        }
    }

    private static class TransformServiceLookup
    implements ServiceLookup {
        private final ImmutableList<InjectionPoint> injectionPoints;

        public TransformServiceLookup(File inputFile, @Nullable TransformParameters parameters, @Nullable ArtifactTransformDependencies artifactTransformDependencies) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifact.class, () -> inputFile));
            if (parameters != null) {
                builder.add((Object)InjectionPoint.injectedByType(parameters.getClass(), () -> parameters));
            } else {
                builder.add((Object)InjectionPoint.injectedByType(TransformParameters.None.class, () -> {
                    throw new UnknownServiceException(TransformParameters.None.class, "Cannot query parameters for artifact transform without parameters.");
                }));
            }
            if (artifactTransformDependencies != null) {
                builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifactDependencies.class, () -> artifactTransformDependencies.getFiles()));
            }
            this.injectionPoints = builder.build();
        }

        @Nullable
        private Object find(Type serviceType, @Nullable Class<? extends Annotation> annotatedWith) {
            TypeToken serviceTypeToken = TypeToken.of((Type)serviceType);
            for (InjectionPoint injectionPoint : this.injectionPoints) {
                if (annotatedWith != injectionPoint.getAnnotation() || !serviceTypeToken.isSupertypeOf(injectionPoint.getInjectedType())) continue;
                return injectionPoint.getValueToInject();
            }
            return null;
        }

        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            return this.find(serviceType, null);
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType, annotatedWith);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }

        private static class InjectionPoint {
            private final Class<? extends Annotation> annotation;
            private final Class<?> injectedType;
            private final Supplier<Object> valueToInject;

            public static InjectionPoint injectedByAnnotation(Class<? extends Annotation> annotation, Supplier<Object> valueToInject) {
                return new InjectionPoint(annotation, InjectionPoint.determineTypeFromAnnotation(annotation), valueToInject);
            }

            public static InjectionPoint injectedByType(Class<?> injectedType, Supplier<Object> valueToInject) {
                return new InjectionPoint(null, injectedType, valueToInject);
            }

            private InjectionPoint(@Nullable Class<? extends Annotation> annotation, Class<?> injectedType, Supplier<Object> valueToInject) {
                this.annotation = annotation;
                this.injectedType = injectedType;
                this.valueToInject = valueToInject;
            }

            private static Class<?> determineTypeFromAnnotation(Class<? extends Annotation> annotation) {
                Class[] supportedTypes = annotation.getAnnotation(InjectionPointQualifier.class).supportedTypes();
                if (supportedTypes.length != 1) {
                    throw new IllegalArgumentException("Cannot determine supported type for annotation " + annotation.getName());
                }
                return supportedTypes[0];
            }

            @Nullable
            public Class<? extends Annotation> getAnnotation() {
                return this.annotation;
            }

            public Class<?> getInjectedType() {
                return this.injectedType;
            }

            public Object getValueToInject() {
                return this.valueToInject.get();
            }
        }
    }
}

