/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v2, @NotNull FunctionCodegen functionCodegen2, @NotNull MemberCodegen<?> memberCodegen) {
        this.state = functionCodegen2.state;
        this.v = v2;
        this.functionCodegen = functionCodegen2;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context;
        this.memberCodegen = memberCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property);
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor2, property.getGetter(), property.getSetter());
    }

    public void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, entry);
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Destructuring declaration entry" + entry.getName() + " should have a property descriptor: " + variableDescriptor, entry);
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)variableDescriptor;
        this.genDestructuringDeclaration(entry, propertyDescriptor2);
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2, @Nullable KtPropertyAccessor setter2) {
        boolean isDefaultGetterAndSetter;
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        this.genBackingFieldAndAnnotations(declaration, descriptor2);
        boolean bl = isDefaultGetterAndSetter = PropertyCodegen.isDefaultAccessor(getter2) && PropertyCodegen.isDefaultAccessor(setter2);
        if (this.isAccessorNeeded(declaration, descriptor2, getter2, isDefaultGetterAndSetter)) {
            this.generateGetter(declaration, descriptor2, getter2);
        }
        if (this.isAccessorNeeded(declaration, descriptor2, setter2, isDefaultGetterAndSetter)) {
            this.generateSetter(declaration, descriptor2, setter2);
        }
    }

    private static boolean isDefaultAccessor(@Nullable KtPropertyAccessor accessor) {
        return accessor == null || !accessor.hasBody();
    }

    private void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry, @NotNull PropertyDescriptor descriptor2) {
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        if (UnderscoreUtilKt.isSingleUnderscore(entry)) {
            return;
        }
        this.genBackingFieldAndAnnotations(entry, descriptor2);
        this.generateGetter(entry, descriptor2, null);
        this.generateSetter(entry, descriptor2, null);
    }

    private void genBackingFieldAndAnnotations(@Nullable KtNamedDeclaration declaration, @NotNull PropertyDescriptor descriptor2) {
        boolean isBackingFieldOwner;
        boolean bl = descriptor2.isConst() && !Visibilities.isPrivate(descriptor2.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : (isBackingFieldOwner = CodegenContextUtil.isImplementationOwner(this.context, descriptor2));
        assert (declaration != null) : "Declaration is null: " + descriptor2 + " (context=" + this.context + ")";
        this.generateBackingField(declaration, descriptor2, isBackingFieldOwner);
        this.generateSyntheticMethodIfNeeded(descriptor2, isBackingFieldOwner);
    }

    private boolean isAccessorNeeded(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor accessor, boolean isDefaultGetterAndSetter) {
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        boolean isDefaultAccessor = PropertyCodegen.isDefaultAccessor(accessor);
        if (this.kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (declaration == null) {
            return true;
        }
        if (declaration.hasDelegate() || declaration.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return !Visibilities.isPrivate(descriptor2.getVisibility()) || !isDefaultGetterAndSetter;
        }
        if (PropertyCodegen.isNonConstTopLevelPropertyInMultifileClass(declaration, descriptor2)) {
            return true;
        }
        if (Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        if (accessor != null && accessor.isSetter() && Visibilities.isPrivate(descriptor2.getSetter().getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    private static boolean isNonConstTopLevelPropertyInMultifileClass(@NotNull KtProperty declaration, @NotNull PropertyDescriptor descriptor2) {
        return !descriptor2.isConst() && descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration);
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2, @NotNull OwnerKind kind) {
        if (JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        if (kind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        Visibility visibility = descriptor2.getVisibility();
        if (InlineClassesUtilsKt.isInlineClass(descriptor2.getContainingDeclaration())) {
            return visibility.isPublicAPI();
        }
        return !Visibilities.isPrivate(visibility);
    }

    public void generatePrimaryConstructorProperty(@NotNull KtParameter parameter, @NotNull PropertyDescriptor descriptor2) {
        this.genBackingFieldAndAnnotations(parameter, descriptor2);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor2, this.context.getContextKind())) {
            this.generateGetter(parameter, descriptor2, null);
            this.generateSetter(parameter, descriptor2, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(@NotNull KtParameter parameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        JvmMethodGenericSignature signature = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        Method asmMethod = signature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(parameter, descriptor2), 1025, asmMethod.getName(), asmMethod.getDescriptor(), signature.getGenericsSignature(), null);
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        assert (getter2 != null) : "Annotation property should have a getter: " + descriptor2;
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2, asmMethod);
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.state).genAnnotations(getter2, asmMethod.getReturnType());
        KtExpression defaultValue = this.loadAnnotationArgumentDefaultValue(parameter, descriptor2, expectedAnnotationConstructor);
        if (defaultValue != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext, true, this.state.getShouldInlineConstVals());
            assert (!this.state.getClassBuilderMode().generateBodies || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.memberCodegen, this.state);
                annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
            }
        }
        mv.visitEnd();
    }

    private KtExpression loadAnnotationArgumentDefaultValue(@NotNull KtParameter ktParameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        KtExpression value = ktParameter.getDefaultValue();
        if (value != null) {
            return value;
        }
        if (expectedAnnotationConstructor != null) {
            ValueParameterDescriptor expectedParameter = (ValueParameterDescriptor)CollectionsKt.single(expectedAnnotationConstructor.getValueParameters(), parameter -> parameter.getName().equals(descriptor2.getName()));
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameter);
            if (!(element instanceof KtParameter)) {
                this.state.getDiagnostics().report(Errors.EXPECTED_FUNCTION_SOURCE_WITH_DEFAULT_ARGUMENTS_NOT_FOUND.on(ktParameter));
                return null;
            }
            return ((KtParameter)element).getDefaultValue();
        }
        return null;
    }

    private void generateBackingField(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, boolean isBackingFieldOwner) {
        Object defaultValue;
        boolean isDelegate;
        if (JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) {
            return;
        }
        boolean bl = isDelegate = p instanceof KtProperty && ((KtProperty)p).hasDelegate();
        if (isDelegate) {
            defaultValue = null;
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            ConstantValue<?> initializer2;
            defaultValue = this.shouldWriteFieldInitializer(descriptor2) ? ((initializer2 = descriptor2.getCompileTimeInitializer()) == null ? null : initializer2.getValue()) : null;
        } else {
            return;
        }
        this.generateBackingField(p, descriptor2, isDelegate, defaultValue, isBackingFieldOwner);
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2, boolean isBackingFieldOwner) {
        Annotations annotations2 = descriptor2.getAnnotations();
        if (annotations2.isEmpty()) {
            return;
        }
        Method signature = this.getSyntheticMethodSignature(descriptor2);
        if (this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplementationOwner(this.context, descriptor2)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, signature);
        }
        if (isBackingFieldOwner && (!DescriptorUtils.isInterface(this.context.getContextDescriptor()) || FunctionCodegen.processInterfaceMethod(descriptor2, this.kind, false, true, this.state.getJvmDefaultMode()))) {
            this.memberCodegen.generateSyntheticAnnotationsMethod(descriptor2, signature, annotations2);
        }
    }

    @NotNull
    private Method getSyntheticMethodSignature(@NotNull PropertyDescriptor descriptor2) {
        ReceiverParameterDescriptor receiver2 = descriptor2.getExtensionReceiverParameter();
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor2.getName());
        String desc = receiver2 == null ? "()V" : "(" + this.typeMapper.mapType(receiver2.getType()) + ")V";
        return new Method(name, desc);
    }

    private void generateBackingField(@NotNull KtNamedDeclaration element, @NotNull PropertyDescriptor propertyDescriptor2, boolean isDelegate, @Nullable Object defaultValue, boolean isBackingFieldOwner) {
        FieldDescriptor annotatedField = isDelegate ? propertyDescriptor2.getDelegateField() : propertyDescriptor2.getBackingField();
        int modifiers2 = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor2);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            modifiers2 |= flagAnnotation.getJvmFlag(annotatedField);
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers2 |= 8;
        }
        if (!(propertyDescriptor2.isLateInit() || propertyDescriptor2.isVar() && !isDelegate)) {
            modifiers2 |= 0x10;
        }
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor2)) {
            modifiers2 |= 0x1000;
        }
        KotlinType kotlinType2 = isDelegate ? PropertyCodegen.getDelegateTypeForProperty((KtProperty)element, propertyDescriptor2, this.bindingContext) : propertyDescriptor2.getType();
        Type type2 = this.typeMapper.mapType(kotlinType2);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor2)) {
            modifiers2 |= 8;
            if (JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor2)) {
                ImplementationBodyCodegen codegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen.v;
                backingFieldContext = codegen.context;
            }
        }
        modifiers2 |= AsmUtil.getVisibilityForBackingField(propertyDescriptor2, isDelegate);
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor2)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor2, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor2, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor2, Pair.create(type2, name));
        if (isBackingFieldOwner) {
            FieldVisitor fv = builder.newField(JvmDeclarationOriginKt.OtherOrigin(element, propertyDescriptor2), modifiers2, name, type2.getDescriptor(), isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType2, propertyDescriptor2), defaultValue);
            if (annotatedField != null) {
                AnnotationCodegen.forField(fv, this.memberCodegen, this.state).genAnnotations(annotatedField, type2);
            }
        }
    }

    @NotNull
    public static KotlinType getDelegateTypeForProperty(@NotNull KtProperty p, @NotNull PropertyDescriptor propertyDescriptor2, @NotNull BindingContext bindingContext) {
        KotlinType delegateType = null;
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor2);
        KtExpression delegateExpression = p.getDelegateExpression();
        if (provideDelegateResolvedCall != null) {
            delegateType = provideDelegateResolvedCall.getResultingDescriptor().getReturnType();
        } else if (delegateExpression != null) {
            delegateType = bindingContext.getType(delegateExpression);
        }
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        return delegateType;
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (!descriptor2.isConst() && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoConstantValueAttributeForNonConstVals)) {
            return false;
        }
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2) {
        this.generateAccessor(p, getter2, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor setter2) {
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(p, setter2, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtNamedDeclaration p, @Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (this.context instanceof MultifileClassFacadeContext && (Visibilities.isPrivate(accessorDescriptor.getVisibility()) || AsmUtil.getVisibilityAccessFlag(accessorDescriptor) == 2)) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (p instanceof KtProperty && ((KtProperty)p).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(accessor != null ? accessor : p, accessorDescriptor), accessorDescriptor, strategy);
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull ExpressionCodegen codegen, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull StackValue receiver2, @NotNull PropertyDescriptor propertyDescriptor2) {
        codegen.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(1).asElement(), PropertyCodegen.getDelegatedPropertyMetadata(propertyDescriptor2, codegen.getBindingContext()));
        return codegen.invokeFunction(resolvedCall2, receiver2);
    }

    @NotNull
    public static StackValue getDelegatedPropertyMetadata(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        int index2;
        Type owner = bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, descriptor2);
        assert (owner != null) : "Delegated property owner not found: " + descriptor2;
        List<VariableDescriptorWithAccessors> allDelegatedProperties = bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES, owner);
        int n = index2 = allDelegatedProperties == null ? -1 : allDelegatedProperties.indexOf(descriptor2);
        if (index2 < 0) {
            throw new AssertionError((Object)("Delegated property not found in " + owner + ": " + descriptor2));
        }
        StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
        return StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, null, array, StackValue.constant(index2));
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter2;
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter2 = delegate.getGetter();
        if (getter2 != null) {
            this.functionCodegen.genDelegate(getter2, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter2 = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter2, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            super(state2);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            InstructionAdapter v2 = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.propertyAccessorDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature.toString();
            PropertyDescriptor propertyDescriptor2 = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor2, true, null, StackValue.LOCAL_0);
            StackValue.Property delegate = property.getDelegateOrNull();
            assert (delegate != null) : "No delegate for delegated property: " + propertyDescriptor2;
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen, resolvedCall2, delegate, propertyDescriptor2);
            Type asmType = signature.getReturnType();
            KotlinType kotlinReturnType = this.propertyAccessorDescriptor.getOriginal().getReturnType();
            lastValue.put(asmType, kotlinReturnType, v2);
            v2.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            super(state2);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            InstructionAdapter v2 = codegen.v;
            PropertyDescriptor propertyDescriptor2 = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor2, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor2);
            if (jetProperty instanceof KtProperty || jetProperty instanceof KtParameter) {
                codegen.markLineNumber((KtElement)jetProperty, false);
            }
            if (this.propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature.getReturnType();
                property.put(type2, v2);
                v2.areturn(type2);
            } else if (this.propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters2 = this.propertyAccessorDescriptor.getValueParameters();
                assert (valueParameters2.size() == 1) : "Property setter should have only one value parameter but has " + this.propertyAccessorDescriptor;
                int parameterIndex = codegen.lookupLocalIndex(valueParameters2.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.propertyAccessorDescriptor;
                Type type3 = codegen.typeMapper.mapType(propertyDescriptor2);
                property.store(StackValue.local(parameterIndex, type3), codegen.v);
                v2.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.propertyAccessorDescriptor);
            }
        }
    }
}

