/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final KtArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(1);
        }
        return new ArrayAccessTranslator(expression2, context);
    }

    private ArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(2);
        }
        if (context == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(3);
        }
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(3);
        }
        super(context);
        this.expression = expression2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.getArrayExpression());
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(4);
        }
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(4);
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression) {
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(5);
        }
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(5);
        }
        JsExpression jsExpression = this.translateAsMethodCall(arrayExpression, null);
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(6);
        }
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(6);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(7);
        }
        if (setTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(7);
        }
        JsExpression jsExpression = this.translateAsMethodCall(this.getArrayExpression(), setTo);
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(8);
        }
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(8);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @Nullable JsExpression toSetTo) {
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(9);
        }
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(9);
        }
        boolean isGetter = toSetTo == null;
        TranslationContext context = this.context();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter);
        if (!isGetter) {
            context = this.contextWithValueParameterAliasInArrayGetAccess(toSetTo);
        }
        JsExpression jsExpression = CallTranslator.translate(context, resolvedCall2, arrayExpression);
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(10);
        }
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(10);
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression getArrayExpression() {
        KtExpression arrayExpression = this.expression.getArrayExpression();
        assert (arrayExpression != null) : "Code with parsing errors shouldn't be translated";
        JsExpression jsExpression = Translation.translateAsExpression(arrayExpression, this.context());
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(11);
        }
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(11);
        }
        return jsExpression;
    }

    @NotNull
    private TranslationContext contextWithValueParameterAliasInArrayGetAccess(@NotNull JsExpression toSetTo) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        List<ResolvedValueArgument> arguments2;
        if (toSetTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(12);
        }
        if (toSetTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(12);
        }
        if ((arguments2 = (resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, false)).getValueArgumentsByIndex()) == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor());
        }
        ResolvedValueArgument lastArgument = arguments2.get(arguments2.size() - 1);
        assert (lastArgument instanceof ExpressionValueArgument) : "Last argument of array-like setter must be ExpressionValueArgument: " + lastArgument;
        ValueArgument valueArgument = ((ExpressionValueArgument)lastArgument).getValueArgument();
        assert (valueArgument != null);
        KtExpression element = valueArgument.getArgumentExpression();
        TranslationContext translationContext = this.context().innerContextWithAliasesForExpressions(Collections.singletonMap(element, toSetTo));
        if (translationContext == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(13);
        }
        if (translationContext == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(13);
        }
        return translationContext;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        JsExpression arrayExpression = this.context().cacheExpressionIfNeeded(this.getArrayExpression());
        aliases.put(this.expression.getArrayExpression(), arrayExpression);
        for (KtExpression ktExpression : this.expression.getIndexExpressions()) {
            JsExpression jsExpression = this.context().cacheExpressionIfNeeded(Translation.translateAsExpression(ktExpression, this.context()));
            aliases.put(ktExpression, jsExpression);
        }
        CachedArrayAccessTranslator cachedArrayAccessTranslator = new CachedArrayAccessTranslator(this.expression, this.context().innerContextWithAliasesForExpressions(aliases), arrayExpression);
        if (cachedArrayAccessTranslator == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(14);
        }
        if (cachedArrayAccessTranslator == null) {
            ArrayAccessTranslator.$$$reportNull$$$1(14);
        }
        return cachedArrayAccessTranslator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSetTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsMethodCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "translateAsMethodCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSetTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsMethodCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "translateAsMethodCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedArrayAccessTranslator
    extends ArrayAccessTranslator {
        @NotNull
        private final JsExpression arrayExpression;

        protected CachedArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context, @NotNull JsExpression arrayExpression) {
            if (expression2 == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$1(0);
            }
            if (context == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$1(1);
            }
            if (arrayExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$1(2);
            }
            if (expression2 == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(1);
            }
            if (arrayExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(2);
            }
            super(expression2, context);
            this.arrayExpression = arrayExpression;
        }

        @Override
        @NotNull
        protected JsExpression getArrayExpression() {
            JsExpression jsExpression = this.arrayExpression;
            if (jsExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(3);
            }
            if (jsExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$1(3);
            }
            return jsExpression;
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            CachedArrayAccessTranslator cachedArrayAccessTranslator = this;
            if (cachedArrayAccessTranslator == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(4);
            }
            if (cachedArrayAccessTranslator == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$1(4);
            }
            return cachedArrayAccessTranslator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

