/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.tasks.FinalizeAction;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultResolvedArtifact
implements ResolvedArtifact,
ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependency buildDependencies;
    private volatile Factory<File> artifactSource;
    private final ResolvableArtifact sourceArtifact;
    private volatile File file;
    private volatile Throwable failure;

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, Factory<File> artifactSource) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.sourceArtifact = null;
        this.artifactSource = artifactSource;
    }

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, ResolvableArtifact sourceArtifact, File artifactFile) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = null;
        this.sourceArtifact = sourceArtifact;
        this.file = artifactFile;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)new FinalizeAction(){

            public TaskDependencyContainer getDependencies() {
                return new TaskDependencyContainer(){

                    public void visitDependencies(TaskDependencyResolveContext context) {
                        if (DefaultResolvedArtifact.this.buildDependencies != null) {
                            context.add((Object)DefaultResolvedArtifact.this.buildDependencies);
                        } else if (DefaultResolvedArtifact.this.sourceArtifact != null) {
                            context.add((Object)DefaultResolvedArtifact.this.sourceArtifact);
                        }
                    }
                };
            }

            public void execute(Task task) {
                if (DefaultResolvedArtifact.this.isResolveSynchronously()) {
                    try {
                        DefaultResolvedArtifact.this.getFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ResolvedModuleVersion getModuleVersion() {
        return new DefaultResolvedModuleVersion(this.owner);
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        return other.owner.equals(this.owner) && other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.artifactId.hashCode();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this;
    }

    @Override
    public boolean isResolveSynchronously() {
        if (this.artifactId.getComponentIdentifier() instanceof ProjectComponentIdentifier) {
            return true;
        }
        return this.file != null || this.failure != null;
    }

    @Override
    public File getFile() {
        File f = this.file;
        if (f == null) {
            Throwable err = this.failure;
            if (err != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)err);
            }
            try {
                this.file = f = (File)this.artifactSource.create();
            }
            catch (Exception e) {
                this.failure = err = e;
                throw UncheckedException.throwAsUncheckedException((Throwable)err);
            }
        }
        return f;
    }
}

