/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public final class JsDynamicDeclarationChecker
implements DeclarationChecker {
    public static final JsDynamicDeclarationChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block5: {
            BindingTrace trace;
            block4: {
                KtExpression delegateExpression;
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                        trace = context.getTrace();
                        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof VariableDescriptorWithAccessors)) break block4;
                        KtExpression ktExpression = ((KtProperty)declaration2).getDelegateExpression();
                        if (ktExpression == null) break block5;
                        KtExpression ktExpression2 = ktExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        delegateExpression = ktExpression2;
                        boolean bl3 = false;
                        ResolvedCall provideDelegateCall = (ResolvedCall)trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, descriptor2);
                        if (provideDelegateCall == null) break block6;
                        Object d = provideDelegateCall.getResultingDescriptor();
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"provideDelegateCall.resultingDescriptor");
                        KotlinType kotlinType2 = ((FunctionDescriptor)d).getReturnType();
                        if (kotlinType2 != null && DynamicTypesKt.isDynamic(kotlinType2)) break block7;
                    }
                    KotlinType kotlinType3 = trace.getType(delegateExpression);
                    if (kotlinType3 == null) break block5;
                    if (!DynamicTypesKt.isDynamic(kotlinType3)) break block5;
                }
                trace.report(ErrorsJs.PROPERTY_DELEGATION_BY_DYNAMIC.on(delegateExpression));
                break block5;
            }
            if (declaration2 instanceof KtClassOrObject) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((KtClassOrObject)declaration2).getSuperTypeListEntries();
                boolean $i$f$filterIsInstance = false;
                Iterable bl3 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtDelegatedSuperTypeEntry delegateDecl : (List)destination$iv$iv) {
                    KtExpression delegateExpr;
                    if (delegateDecl.getDelegateExpression() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)delegateExpr, (String)"delegateDecl.delegateExpression ?: continue");
                    KotlinType kotlinType4 = trace.getType(delegateExpr);
                    if (kotlinType4 == null) continue;
                    if (!DynamicTypesKt.isDynamic(kotlinType4)) continue;
                    trace.report(ErrorsJs.DELEGATION_BY_DYNAMIC.on(delegateExpr));
                }
            }
        }
    }

    private JsDynamicDeclarationChecker() {
    }

    static {
        JsDynamicDeclarationChecker jsDynamicDeclarationChecker;
        INSTANCE = jsDynamicDeclarationChecker = new JsDynamicDeclarationChecker();
    }
}

