/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.EngineDiscoveryResultValidator;
import org.junit.platform.launcher.core.ExecutionListenerAdapter;
import org.junit.platform.launcher.core.Root;
import org.junit.platform.launcher.core.StreamInterceptingTestExecutionListener;
import org.junit.platform.launcher.core.TestExecutionListenerRegistry;

class DefaultLauncher
implements Launcher {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLauncher.class);
    private final TestExecutionListenerRegistry listenerRegistry = new TestExecutionListenerRegistry();
    private final EngineDiscoveryResultValidator discoveryResultValidator = new EngineDiscoveryResultValidator();
    private final Iterable<TestEngine> testEngines;

    DefaultLauncher(Iterable<TestEngine> testEngines) {
        Preconditions.condition((testEngines != null && testEngines.iterator().hasNext() ? 1 : 0) != 0, () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        this.testEngines = DefaultLauncher.validateEngineIds(testEngines);
    }

    private static Iterable<TestEngine> validateEngineIds(Iterable<TestEngine> testEngines) {
        HashSet<String> ids = new HashSet<String>();
        for (TestEngine testEngine : testEngines) {
            if (!DefaultLauncher.validateReservedIds(testEngine)) {
                logger.warn(() -> String.format("Third-party TestEngine implementations are forbidden to use the reserved 'junit-' prefix for their ID: '%s'", testEngine.getId()));
            }
            if (ids.add(testEngine.getId())) continue;
            throw new JUnitException(String.format("Cannot create Launcher for multiple engines with the same ID '%s'.", testEngine.getId()));
        }
        return testEngines;
    }

    private static boolean validateReservedIds(TestEngine testEngine) {
        String engineId = testEngine.getId();
        if (!engineId.startsWith("junit-")) {
            return true;
        }
        if (engineId.equals("junit-jupiter")) {
            DefaultLauncher.validateWellKnownClassName(testEngine, "org.junit.jupiter.engine.JupiterTestEngine");
            return true;
        }
        if (engineId.equals("junit-vintage")) {
            DefaultLauncher.validateWellKnownClassName(testEngine, "org.junit.vintage.engine.VintageTestEngine");
            return true;
        }
        return false;
    }

    private static void validateWellKnownClassName(TestEngine testEngine, String expectedClassName) {
        String actualClassName = testEngine.getClass().getName();
        if (actualClassName.equals(expectedClassName)) {
            return;
        }
        throw new JUnitException(String.format("Third-party TestEngine '%s' is forbidden to use the reserved '%s' TestEngine ID.", actualClassName, testEngine.getId()));
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        Preconditions.notEmpty((Object[])listeners, (String)"listeners array must not be null or empty");
        Preconditions.containsNoNullElements((Object[])listeners, (String)"individual listeners must not be null");
        this.listenerRegistry.registerListeners(listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)discoveryRequest, (String)"LauncherDiscoveryRequest must not be null");
        return TestPlan.from(this.discoverRoot(discoveryRequest, "discovery").getEngineDescriptors());
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Preconditions.notNull((Object)discoveryRequest, (String)"LauncherDiscoveryRequest must not be null");
        Preconditions.notNull((Object)listeners, (String)"TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements((Object[])listeners, (String)"individual listeners must not be null");
        this.execute(this.discoverRoot(discoveryRequest, "execution"), discoveryRequest.getConfigurationParameters(), listeners);
    }

    TestExecutionListenerRegistry getTestExecutionListenerRegistry() {
        return this.listenerRegistry;
    }

    private Root discoverRoot(LauncherDiscoveryRequest discoveryRequest, String phase) {
        Root root = new Root();
        for (TestEngine testEngine : this.testEngines) {
            boolean engineIsExcluded = discoveryRequest.getEngineFilters().stream().map(engineFilter -> engineFilter.apply(testEngine)).anyMatch(FilterResult::excluded);
            if (engineIsExcluded) {
                logger.debug(() -> String.format("Test discovery for engine '%s' was skipped due to an EngineFilter in phase '%s'.", testEngine.getId(), phase));
                continue;
            }
            logger.debug(() -> String.format("Discovering tests during Launcher %s phase in engine '%s'.", phase, testEngine.getId()));
            Optional<TestDescriptor> engineRoot = this.discoverEngineRoot(testEngine, discoveryRequest);
            engineRoot.ifPresent(rootDescriptor -> root.add(testEngine, (TestDescriptor)rootDescriptor));
        }
        root.applyPostDiscoveryFilters(discoveryRequest);
        root.prune();
        return root;
    }

    private Optional<TestDescriptor> discoverEngineRoot(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        UniqueId uniqueEngineId = UniqueId.forEngine((String)testEngine.getId());
        try {
            TestDescriptor engineRoot = testEngine.discover((EngineDiscoveryRequest)discoveryRequest, uniqueEngineId);
            this.discoveryResultValidator.validate(testEngine, engineRoot);
            return Optional.of(engineRoot);
        }
        catch (Throwable throwable) {
            this.handleThrowable(testEngine, "discover", throwable);
            return Optional.empty();
        }
    }

    private void execute(Root root, ConfigurationParameters configurationParameters, TestExecutionListener ... listeners) {
        TestExecutionListenerRegistry listenerRegistry = this.buildListenerRegistryForExecution(listeners);
        this.withInterceptedStreams(configurationParameters, listenerRegistry, testExecutionListener -> {
            TestPlan testPlan = TestPlan.from(root.getEngineDescriptors());
            testExecutionListener.testPlanExecutionStarted(testPlan);
            ExecutionListenerAdapter engineExecutionListener = new ExecutionListenerAdapter(testPlan, (TestExecutionListener)testExecutionListener);
            for (TestEngine testEngine : root.getTestEngines()) {
                TestDescriptor testDescriptor = root.getTestDescriptorFor(testEngine);
                this.execute(testEngine, new ExecutionRequest(testDescriptor, (EngineExecutionListener)engineExecutionListener, configurationParameters));
            }
            testExecutionListener.testPlanExecutionFinished(testPlan);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withInterceptedStreams(ConfigurationParameters configurationParameters, TestExecutionListenerRegistry listenerRegistry, Consumer<TestExecutionListener> action) {
        TestExecutionListener testExecutionListener = listenerRegistry.getCompositeTestExecutionListener();
        Optional<StreamInterceptingTestExecutionListener> streamInterceptingTestExecutionListener = StreamInterceptingTestExecutionListener.create(configurationParameters, testExecutionListener::reportingEntryPublished);
        streamInterceptingTestExecutionListener.ifPresent(xva$0 -> listenerRegistry.registerListeners((TestExecutionListener)xva$0));
        try {
            action.accept(testExecutionListener);
        }
        finally {
            streamInterceptingTestExecutionListener.ifPresent(StreamInterceptingTestExecutionListener::unregister);
        }
    }

    private TestExecutionListenerRegistry buildListenerRegistryForExecution(TestExecutionListener ... listeners) {
        if (listeners.length == 0) {
            return this.listenerRegistry;
        }
        TestExecutionListenerRegistry registry = new TestExecutionListenerRegistry(this.listenerRegistry);
        registry.registerListeners(listeners);
        return registry;
    }

    private void execute(TestEngine testEngine, ExecutionRequest executionRequest) {
        try {
            testEngine.execute(executionRequest);
        }
        catch (Throwable throwable) {
            this.handleThrowable(testEngine, "execute", throwable);
        }
    }

    private void handleThrowable(TestEngine testEngine, String phase, Throwable throwable) {
        logger.warn(throwable, () -> String.format("TestEngine with ID '%s' failed to %s tests", testEngine.getId(), phase));
        BlacklistedExceptions.rethrowIfBlacklisted((Throwable)throwable);
    }
}

