/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;

public class SnapshotWatchedDirectoryFinder {
    public static ImmutableList<Path> getDirectoriesToWatch(CompleteFileSystemLocationSnapshot snapshot) {
        Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
        switch (snapshot.getType()) {
            case RegularFile: {
                return ImmutableList.of((Object)path.getParent());
            }
            case Directory: {
                Path ancestorToWatch = path.getParent();
                return ancestorToWatch == null ? ImmutableList.of((Object)path) : ImmutableList.of((Object)ancestorToWatch, (Object)path);
            }
            case Missing: {
                return ImmutableList.of((Object)SnapshotWatchedDirectoryFinder.findFirstExistingAncestor(path));
            }
        }
        throw new AssertionError();
    }

    private static Path findFirstExistingAncestor(Path path) {
        Path candidate = path;
        do {
            if ((candidate = candidate.getParent()) != null) continue;
            throw new IllegalStateException("Couldn't find existing ancestor for " + path);
        } while (!Files.isDirectory(candidate, new LinkOption[0]));
        return candidate;
    }
}

