/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.IncubationLogger;

public class DefaultProjectsPreparer
implements ProjectsPreparer {
    private final BuildLoader buildLoader;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectConfigurer projectConfigurer;
    private final BuildStateRegistry buildRegistry;
    private final ModelConfigurationListener modelConfigurationListener;

    public DefaultProjectsPreparer(ProjectConfigurer projectConfigurer, BuildStateRegistry buildRegistry, BuildLoader buildLoader, ModelConfigurationListener modelConfigurationListener, BuildOperationExecutor buildOperationExecutor) {
        this.projectConfigurer = projectConfigurer;
        this.buildRegistry = buildRegistry;
        this.buildLoader = buildLoader;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        this.maybeInformAboutIncubatingMode(gradle);
        this.buildLoader.load(gradle.getSettings(), gradle);
        if (gradle.isRootBuild()) {
            this.buildRegistry.beforeConfigureRootBuild();
        }
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
        this.modelConfigurationListener.onConfigure(gradle);
    }

    private void maybeInformAboutIncubatingMode(GradleInternal gradle) {
        StartParameterInternal startParameter = gradle.getStartParameter();
        if (startParameter.isConfigureOnDemand()) {
            IncubationLogger.incubatingFeatureUsed((String)"Configuration on demand");
        }
    }
}

