/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.vfs.VirtualFileSystem;

@ServiceScope(value=Scopes.BuildSession)
public class RoutingVirtualFileSystem
implements VirtualFileSystem {
    private final GlobalCacheLocations globalCacheLocations;
    private final VirtualFileSystem gradleUserHomeVirtualFileSystem;
    private final VirtualFileSystem buildScopedVirtualFileSystem;
    private final BooleanSupplier vfsRetained;

    public RoutingVirtualFileSystem(GlobalCacheLocations globalCacheLocations, VirtualFileSystem gradleUserHomeVirtualFileSystem, VirtualFileSystem buildScopedVirtualFileSystem, BooleanSupplier vfsRetained) {
        this.globalCacheLocations = globalCacheLocations;
        this.gradleUserHomeVirtualFileSystem = gradleUserHomeVirtualFileSystem;
        this.buildScopedVirtualFileSystem = buildScopedVirtualFileSystem;
        this.vfsRetained = vfsRetained;
    }

    public <T> T read(String location, Function<CompleteFileSystemLocationSnapshot, T> visitor) {
        return (T)this.getVirtualFileSystemFor(location).read(location, visitor);
    }

    public <T> Optional<T> readRegularFileContentHash(String location, Function<HashCode, T> visitor) {
        return this.getVirtualFileSystemFor(location).readRegularFileContentHash(location, visitor);
    }

    public void read(String location, SnapshottingFilter filter, Consumer<CompleteFileSystemLocationSnapshot> visitor) {
        this.getVirtualFileSystemFor(location).read(location, filter, visitor);
    }

    public void update(Iterable<String> locations, Runnable action) {
        if (Iterables.isEmpty(locations)) {
            return;
        }
        if (this.vfsRetained.getAsBoolean()) {
            this.gradleUserHomeVirtualFileSystem.update(locations, action);
        } else {
            Iterable immutableLocations = Iterables.filter(locations, arg_0 -> ((GlobalCacheLocations)this.globalCacheLocations).isInsideGlobalCache(arg_0));
            int immutableLocationsSize = Iterables.size((Iterable)immutableLocations);
            if (immutableLocationsSize == 0) {
                this.buildScopedVirtualFileSystem.update(locations, action);
            } else if (immutableLocationsSize == Iterables.size(locations)) {
                this.gradleUserHomeVirtualFileSystem.update(locations, action);
            } else {
                Iterable mutableLocations = Iterables.filter(locations, location -> !this.globalCacheLocations.isInsideGlobalCache(location));
                this.gradleUserHomeVirtualFileSystem.update(immutableLocations, action);
                this.buildScopedVirtualFileSystem.update(mutableLocations, action);
            }
        }
    }

    public void invalidateAll() {
        if (this.vfsRetained.getAsBoolean()) {
            this.gradleUserHomeVirtualFileSystem.invalidateAll();
        } else {
            this.buildScopedVirtualFileSystem.invalidateAll();
        }
    }

    public void updateWithKnownSnapshot(CompleteFileSystemLocationSnapshot snapshot) {
        this.getVirtualFileSystemFor(snapshot.getAbsolutePath()).updateWithKnownSnapshot(snapshot);
    }

    private VirtualFileSystem getVirtualFileSystemFor(String location) {
        return this.vfsRetained.getAsBoolean() ? this.gradleUserHomeVirtualFileSystem : (this.globalCacheLocations.isInsideGlobalCache(location) ? this.gradleUserHomeVirtualFileSystem : this.buildScopedVirtualFileSystem);
    }
}

