/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaFeatureSpec;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.jvm.DefaultModularitySpec;

public class DefaultJavaPluginExtension
implements JavaPluginExtension {
    private static final Pattern VALID_FEATURE_NAME = Pattern.compile("[a-zA-Z0-9]+");
    private final JavaPluginConvention convention;
    private final ConfigurationContainer configurations;
    private final ObjectFactory objectFactory;
    private final SoftwareComponentContainer components;
    private final TaskContainer tasks;
    private final Project project;
    private final ModularitySpec modularity;

    public DefaultJavaPluginExtension(JavaPluginConvention convention, Project project) {
        this.convention = convention;
        this.configurations = project.getConfigurations();
        this.objectFactory = project.getObjects();
        this.components = project.getComponents();
        this.tasks = project.getTasks();
        this.project = project;
        this.modularity = (ModularitySpec)project.getObjects().newInstance(DefaultModularitySpec.class, new Object[0]);
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        return this.convention.getSourceCompatibility();
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.convention.setSourceCompatibility(value);
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.convention.getTargetCompatibility();
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.convention.setTargetCompatibility(value);
    }

    @Override
    public void registerFeature(String name, Action<? super FeatureSpec> configureAction) {
        ProjectDerivedCapability defaultCapability = new ProjectDerivedCapability(this.project, name);
        DefaultJavaFeatureSpec spec = new DefaultJavaFeatureSpec(DefaultJavaPluginExtension.validateFeatureName(name), (Capability)defaultCapability, this.convention, this, this.configurations, this.objectFactory, this.components, this.tasks);
        configureAction.execute((Object)spec);
        spec.create();
    }

    @Override
    public void disableAutoTargetJvm() {
        this.convention.disableAutoTargetJvm();
    }

    @Override
    public void withJavadocJar() {
        TaskContainer tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.convention.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("javadocElements", null, "javadoc", (List<Capability>)ImmutableList.of(), main.getJavadocJarTaskName(), tasks.named(main.getJavadocTaskName()), JvmPluginsHelper.findJavaComponent(this.components), configurations, tasks, this.objectFactory);
    }

    @Override
    public void withSourcesJar() {
        TaskContainer tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.convention.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("sourcesElements", null, "sources", (List<Capability>)ImmutableList.of(), main.getSourcesJarTaskName(), main.getAllSource(), JvmPluginsHelper.findJavaComponent(this.components), configurations, tasks, this.objectFactory);
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    private static String validateFeatureName(String name) {
        if (!VALID_FEATURE_NAME.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid feature name '" + name + "'. Must match " + VALID_FEATURE_NAME.pattern());
        }
        return name;
    }
}

