/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.CompareStrategy;

public class AbsolutePathChangeDetector<S>
implements CompareStrategy.ChangeDetector<S> {
    private final ItemComparator<S> itemComparator;
    private final CompareStrategy.ChangeFactory<S> changeFactory;

    public AbsolutePathChangeDetector(ItemComparator<S> itemComparator, CompareStrategy.ChangeFactory<S> changeFactory) {
        this.itemComparator = itemComparator;
        this.changeFactory = changeFactory;
    }

    @Override
    public boolean visitChangesSince(Map<String, S> previous, Map<String, S> current, String propertyTitle, ChangeVisitor visitor) {
        LinkedHashSet<String> unaccountedForPreviousFingerprints = new LinkedHashSet<String>(previous.keySet());
        for (Map.Entry<String, S> currentEntry : current.entrySet()) {
            Change added;
            Change modified;
            S previousFingerprint;
            String currentAbsolutePath = currentEntry.getKey();
            S currentFingerprint = currentEntry.getValue();
            if (!(unaccountedForPreviousFingerprints.remove(currentAbsolutePath) ? !this.itemComparator.hasSameContent(previousFingerprint = previous.get(currentAbsolutePath), currentFingerprint) && !visitor.visitChange(modified = this.changeFactory.modified(currentAbsolutePath, propertyTitle, previousFingerprint, currentFingerprint)) : !visitor.visitChange(added = this.changeFactory.added(currentAbsolutePath, propertyTitle, currentFingerprint)))) continue;
            return false;
        }
        for (String previousAbsolutePath : unaccountedForPreviousFingerprints) {
            Change removed = this.changeFactory.removed(previousAbsolutePath, propertyTitle, previous.get(previousAbsolutePath));
            if (visitor.visitChange(removed)) continue;
            return false;
        }
        return true;
    }

    public static interface ItemComparator<S> {
        public boolean hasSameContent(S var1, S var2);
    }
}

