/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.descriptors.WrappedClassDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FileClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "createFileClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileClassMembers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "", "backend.jvm"})
final class FileClassLowering
implements FileLoweringPass {
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        ArrayList<IrDeclaration> classes2 = new ArrayList<IrDeclaration>();
        ArrayList<IrDeclaration> fileClassMembers = new ArrayList<IrDeclaration>();
        Iterable $this$forEach$iv = irFile.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (it instanceof IrClass) {
                classes2.add(it);
                continue;
            }
            fileClassMembers.add(it);
        }
        if (fileClassMembers.isEmpty()) {
            MetadataSource metadataSource = irFile.getMetadata();
            if (!(metadataSource instanceof MetadataSource.File)) {
                metadataSource = null;
            }
            MetadataSource.File file2 = (MetadataSource.File)metadataSource;
            $this$forEach$iv = file2 != null ? file2.getDescriptors() : null;
            boolean bl = false;
            boolean bl2 = false;
            if ($this$forEach$iv == null || $this$forEach$iv.isEmpty()) {
                return;
            }
        }
        IrClass irFileClass = this.createFileClass(irFile, (List<? extends IrDeclaration>)fileClassMembers);
        classes2.add(irFileClass);
        irFile.getDeclarations().clear();
        irFile.getDeclarations().addAll((Collection<IrDeclaration>)classes2);
    }

    private final IrClass createFileClass(IrFile irFile, List<? extends IrDeclaration> fileClassMembers) {
        SourceManager.FileEntry fileEntry = irFile.getFileEntry();
        JvmFileClassInfo fileClassInfo2 = null;
        ClassDescriptor descriptor2 = null;
        Object object = fileEntry;
        if (object instanceof PsiSourceManager.PsiFileEntry) {
            KtFile ktFile = this.context.getPsiSourceManager().getKtFile((PsiSourceManager.PsiFileEntry)fileEntry);
            if (ktFile == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected file entry: " + fileEntry)));
            }
            KtFile ktFile2 = ktFile;
            fileClassInfo2 = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile2);
            descriptor2 = new WrappedClassDescriptor();
        } else if (object instanceof NaiveSourceBasedFileEntryImpl) {
            fileClassInfo2 = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName(irFile.getFqName(), fileEntry.getName()), false);
            descriptor2 = new WrappedClassDescriptor();
        } else {
            String string2 = "unknown kind of file entry: " + fileEntry;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        int n = fileEntry.getMaxOffset();
        IrDeclarationOrigin irDeclarationOrigin = !fileClassInfo2.getWithJvmMultifileClass() || this.context.getState().getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getInheritMultifileParts()) != false ? (IrDeclarationOriginImpl)IrDeclarationOrigin.FILE_CLASS.INSTANCE : (IrDeclarationOriginImpl)IrDeclarationOrigin.SYNTHETIC_FILE_CLASS.INSTANCE;
        IrClassSymbol irClassSymbol = new IrClassSymbolImpl(descriptor2);
        Name name = fileClassInfo2.getFileClassFqName().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"fileClassInfo.fileClassFqName.shortName()");
        DescriptorVisibility descriptorVisibility = !fileClassInfo2.getWithJvmMultifileClass() ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"if (!fileClassInfo.withJ\u2026lities.PACKAGE_VISIBILITY");
        object = new IrClassImpl(0, n, irDeclarationOrigin, irClassSymbol, name, ClassKind.CLASS, descriptorVisibility, Modality.FINAL, false, false, false, false, false, false, false, null, 65280, null);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        ((WrappedClassDescriptor)descriptor2).bind((IrDeclaration)$this$apply);
        Object object2 = $this$apply;
        ((IrClassImpl)object2).setSuperTypes(CollectionsKt.plus((Collection)((IrClassImpl)object2).getSuperTypes(), (Object)this.context.getIrBuiltIns().getAnyType()));
        ((IrClassImpl)$this$apply).setParent(irFile);
        ((IrClassImpl)$this$apply).getDeclarations().addAll((Collection<IrDeclaration>)fileClassMembers);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$apply);
        Iterable $this$forEach$iv = fileClassMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction it;
            IrDeclarationBase irDeclarationBase;
            boolean bl4;
            boolean bl5;
            IrDeclaration it2 = (IrDeclaration)element$iv;
            boolean bl6 = false;
            it2.setParent((IrDeclarationParent)$this$apply);
            if (!(it2 instanceof IrProperty)) continue;
            if (((IrProperty)it2).getGetter() != null) {
                bl5 = false;
                bl4 = false;
                it = irDeclarationBase;
                boolean bl7 = false;
                it.setParent((IrDeclarationParent)$this$apply);
            }
            if (((IrProperty)it2).getSetter() != null) {
                bl5 = false;
                bl4 = false;
                it = irDeclarationBase;
                boolean bl8 = false;
                it.setParent((IrDeclarationParent)$this$apply);
            }
            if (((IrProperty)it2).getBackingField() == null) continue;
            bl5 = false;
            bl4 = false;
            it = irDeclarationBase;
            boolean bl9 = false;
            it.setParent((IrDeclarationParent)$this$apply);
        }
        Object object3 = $this$apply;
        ((IrClassImpl)object3).setAnnotations(CollectionsKt.plus((Collection)((IrClassImpl)object3).getAnnotations(), (Iterable)irFile.getAnnotations()));
        ((IrClassImpl)$this$apply).setMetadata(irFile.getMetadata());
        Type type2 = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo2.getFileClassFqName());
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"AsmUtil.asmTypeByFqNameW\u2026lassInfo.fileClassFqName)");
        Type partClassType = type2;
        Type facadeClassType = fileClassInfo2.getWithJvmMultifileClass() ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo2.getFacadeClassFqName()) : null;
        PackagePartRegistry packagePartRegistry = this.context.getState().getFactory().getPackagePartRegistry();
        FqName fqName2 = irFile.getFqName();
        String string3 = partClassType.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"partClassType.internalName");
        Type type3 = facadeClassType;
        packagePartRegistry.addPart(fqName2, string3, type3 != null ? type3.getInternalName() : null);
        if (Intrinsics.areEqual((Object)fileClassInfo2.getFileClassFqName(), (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$apply)) ^ true) {
            Map<IrClass, JvmClassName> map2 = this.context.getClassNameOverride();
            JvmClassName jvmClassName = JvmClassName.byInternalName(partClassType.getInternalName());
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026rtClassType.internalName)");
            map2.put((IrClass)$this$apply, jvmClassName);
        }
        if (facadeClassType != null) {
            List list2;
            JvmClassName jvmClassName = JvmClassName.byInternalName(facadeClassType.getInternalName());
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026deClassType.internalName)");
            JvmClassName jvmClassName2 = jvmClassName;
            Map<JvmClassName, List<IrClass>> $this$getOrPut$iv = this.context.getMultifileFacadesToAdd$backend_jvm();
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(jvmClassName2);
            if (value$iv == null) {
                boolean bl10 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(jvmClassName2, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((IrClass)$this$apply);
        }
        return (IrClass)object;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public FileClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }
}

