/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b#\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\t\u001a%\u0010\u0012\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\t\u001a\n\u0010 \u001a\u00020\u0001*\u00020\t\u001a\n\u0010!\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\t\u001a\n\u0010#\u001a\u00020\u0001*\u00020\t\u001a\n\u0010$\u001a\u00020\u0001*\u00020\t\u001a\u0014\u0010%\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010&\u001a\u00020\u0001*\u00020\t\u001a\n\u0010'\u001a\u00020\u0001*\u00020\t\u001a\n\u0010(\u001a\u00020\u0001*\u00020\t\u001a\u0014\u0010)\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010*\u001a\u00020\u0001*\u00020\t\u001a\n\u0010+\u001a\u00020\u0001*\u00020\t\u001a\n\u0010,\u001a\u00020\u0001*\u00020\t\u001a\n\u0010-\u001a\u00020\u0001*\u00020\t\u001a\n\u0010.\u001a\u00020\u0001*\u00020\t\u001a\n\u0010/\u001a\u00020\u0001*\u00020\t\u001a\n\u00100\u001a\u00020\u0001*\u00020\t\u001a\n\u00101\u001a\u00020\u0001*\u00020\t\u001a\n\u00102\u001a\u00020\u0001*\u00020\t\u001a\n\u00103\u001a\u00020\u0001*\u00020\t\u001a\n\u00104\u001a\u00020\u0001*\u00020\t\u001a\n\u00105\u001a\u00020\u0001*\u00020\t\u001a\n\u00106\u001a\u00020\u0001*\u00020\t\u001a\n\u00107\u001a\u00020\u0001*\u00020\t\u001a\n\u00108\u001a\u00020\u0001*\u00020\t\u00a8\u00069"}, d2={"classFqNameEquals", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isArray", "isBoolean", "isBooleanArray", "isByte", "isByteArray", "isChar", "isCharArray", "isCharSequence", "isClassType", "hasQuestionMark", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/name/FqNameUnsafe;Ljava/lang/Boolean;)Z", "isClassWithFqName", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isCollection", "isComparable", "isDouble", "isDoubleArray", "isFloat", "isFloatArray", "isInt", "isIntArray", "isIterable", "isKClass", "isKotlinResult", "isLong", "isLongArray", "isMarkedNullable", "isNotNullClassType", "isNothing", "isNullableAny", "isNullableArray", "isNullableClassType", "isNullableContinuation", "isNullablePrimitiveType", "isNullableString", "isNumber", "isPrimitiveType", "isSequence", "isShort", "isShortArray", "isString", "isStringClassType", "isUByte", "isUInt", "isULong", "isUShort", "isUnit", "ir.tree"})
public final class IrTypePredicatesKt {
    private static final boolean isNotNullClassType(IrType $this$isNotNullClassType, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($this$isNotNullClassType, fqName2, false);
    }

    private static final boolean isNullableClassType(IrType $this$isNullableClassType, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($this$isNullableClassType, fqName2, true);
    }

    private static final boolean isClassType(IrType $this$isClassType, FqNameUnsafe fqName2, Boolean hasQuestionMark) {
        if (!($this$isClassType instanceof IrSimpleType)) {
            return false;
        }
        if (hasQuestionMark != null && Intrinsics.areEqual((Object)((IrSimpleType)$this$isClassType).getHasQuestionMark(), (Object)hasQuestionMark) ^ true) {
            return false;
        }
        return IrTypePredicatesKt.isClassWithFqName(((IrSimpleType)$this$isClassType).getClassifier(), fqName2);
    }

    static /* synthetic */ boolean isClassType$default(IrType irType, FqNameUnsafe fqNameUnsafe, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return IrTypePredicatesKt.isClassType(irType, fqNameUnsafe, bl);
    }

    public static final boolean isClassWithFqName(@NotNull IrClassifierSymbol $this$isClassWithFqName, @NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassWithFqName, (String)"$this$isClassWithFqName");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return $this$isClassWithFqName instanceof IrClassSymbol && IrTypePredicatesKt.classFqNameEquals((IrClassSymbol)$this$isClassWithFqName, fqName2);
    }

    private static final boolean classFqNameEquals(IrClassSymbol symbol2, FqNameUnsafe fqName2) {
        boolean bl = symbol2.isBound();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return IrTypePredicatesKt.classFqNameEquals((IrClass)symbol2.getOwner(), fqName2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean classFqNameEquals(IrClass declaration2, FqNameUnsafe fqName2) {
        if (!Intrinsics.areEqual((Object)declaration2.getName(), (Object)fqName2.shortName())) return false;
        FqName fqName3 = IrUtilsKt.getFqNameWhenAvailable(declaration2);
        if (!Intrinsics.areEqual((Object)fqName2, (Object)(fqName3 != null ? fqName3.toUnsafe() : null))) return false;
        return true;
    }

    public static final boolean isAny(@NotNull IrType $this$isAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isAny, (String)"$this$isAny");
        return IrTypePredicatesKt.isNotNullClassType($this$isAny, StandardNames.FqNames.any);
    }

    public static final boolean isNullableAny(@NotNull IrType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"$this$isNullableAny");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableAny, StandardNames.FqNames.any);
    }

    public static final boolean isString(@NotNull IrType $this$isString) {
        Intrinsics.checkNotNullParameter((Object)$this$isString, (String)"$this$isString");
        return IrTypePredicatesKt.isNotNullClassType($this$isString, StandardNames.FqNames.string);
    }

    public static final boolean isNullableString(@NotNull IrType $this$isNullableString) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableString, (String)"$this$isNullableString");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableString, StandardNames.FqNames.string);
    }

    public static final boolean isStringClassType(@NotNull IrType $this$isStringClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isStringClassType, (String)"$this$isStringClassType");
        return IrTypePredicatesKt.isClassType$default($this$isStringClassType, StandardNames.FqNames.string, null, 2, null);
    }

    public static final boolean isArray(@NotNull IrType $this$isArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isArray, (String)"$this$isArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isArray, StandardNames.FqNames.array);
    }

    public static final boolean isNullableArray(@NotNull IrType $this$isNullableArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableArray, (String)"$this$isNullableArray");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableArray, StandardNames.FqNames.array);
    }

    public static final boolean isCollection(@NotNull IrType $this$isCollection) {
        Intrinsics.checkNotNullParameter((Object)$this$isCollection, (String)"$this$isCollection");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.collection.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.collection.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isCollection, fqNameUnsafe);
    }

    public static final boolean isNothing(@NotNull IrType $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"$this$isNothing");
        return IrTypePredicatesKt.isNotNullClassType($this$isNothing, StandardNames.FqNames.nothing);
    }

    public static final boolean isKClass(@NotNull IrType $this$isKClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isKClass, (String)"$this$isKClass");
        return IrTypePredicatesKt.isNotNullClassType($this$isKClass, StandardNames.FqNames.kClass);
    }

    public static final boolean isPrimitiveType(@NotNull IrType $this$isPrimitiveType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveType, (String)"$this$isPrimitiveType");
            Iterable $this$any$iv = StandardNames.FqNames.fqNameToPrimitiveType.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    if (!IrTypePredicatesKt.isNotNullClassType($this$isPrimitiveType, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isNullablePrimitiveType(@NotNull IrType $this$isNullablePrimitiveType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isNullablePrimitiveType, (String)"$this$isNullablePrimitiveType");
            Iterable $this$any$iv = StandardNames.FqNames.fqNameToPrimitiveType.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    if (!IrTypePredicatesKt.isNullableClassType($this$isNullablePrimitiveType, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isMarkedNullable(@NotNull IrType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"$this$isMarkedNullable");
        IrType irType = $this$isMarkedNullable;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        return irSimpleType != null ? irSimpleType.getHasQuestionMark() : false;
    }

    public static final boolean isUnit(@NotNull IrType $this$isUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnit, (String)"$this$isUnit");
        return IrTypePredicatesKt.isNotNullClassType($this$isUnit, StandardNames.FqNames.unit);
    }

    public static final boolean isBoolean(@NotNull IrType $this$isBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoolean, (String)"$this$isBoolean");
        return IrTypePredicatesKt.isNotNullClassType($this$isBoolean, StandardNames.FqNames._boolean);
    }

    public static final boolean isChar(@NotNull IrType $this$isChar) {
        Intrinsics.checkNotNullParameter((Object)$this$isChar, (String)"$this$isChar");
        return IrTypePredicatesKt.isNotNullClassType($this$isChar, StandardNames.FqNames._char);
    }

    public static final boolean isByte(@NotNull IrType $this$isByte) {
        Intrinsics.checkNotNullParameter((Object)$this$isByte, (String)"$this$isByte");
        return IrTypePredicatesKt.isNotNullClassType($this$isByte, StandardNames.FqNames._byte);
    }

    public static final boolean isShort(@NotNull IrType $this$isShort) {
        Intrinsics.checkNotNullParameter((Object)$this$isShort, (String)"$this$isShort");
        return IrTypePredicatesKt.isNotNullClassType($this$isShort, StandardNames.FqNames._short);
    }

    public static final boolean isInt(@NotNull IrType $this$isInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isInt, (String)"$this$isInt");
        return IrTypePredicatesKt.isNotNullClassType($this$isInt, StandardNames.FqNames._int);
    }

    public static final boolean isLong(@NotNull IrType $this$isLong) {
        Intrinsics.checkNotNullParameter((Object)$this$isLong, (String)"$this$isLong");
        return IrTypePredicatesKt.isNotNullClassType($this$isLong, StandardNames.FqNames._long);
    }

    public static final boolean isUByte(@NotNull IrType $this$isUByte) {
        Intrinsics.checkNotNullParameter((Object)$this$isUByte, (String)"$this$isUByte");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.uByteFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.uByteFqName.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isUByte, fqNameUnsafe);
    }

    public static final boolean isUShort(@NotNull IrType $this$isUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$isUShort, (String)"$this$isUShort");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.uShortFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.uShortFqName.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isUShort, fqNameUnsafe);
    }

    public static final boolean isUInt(@NotNull IrType $this$isUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isUInt, (String)"$this$isUInt");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.uIntFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.uIntFqName.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isUInt, fqNameUnsafe);
    }

    public static final boolean isULong(@NotNull IrType $this$isULong) {
        Intrinsics.checkNotNullParameter((Object)$this$isULong, (String)"$this$isULong");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.uLongFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.uLongFqName.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isULong, fqNameUnsafe);
    }

    public static final boolean isFloat(@NotNull IrType $this$isFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$isFloat, (String)"$this$isFloat");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloat, StandardNames.FqNames._float);
    }

    public static final boolean isDouble(@NotNull IrType $this$isDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$isDouble, (String)"$this$isDouble");
        return IrTypePredicatesKt.isNotNullClassType($this$isDouble, StandardNames.FqNames._double);
    }

    public static final boolean isNumber(@NotNull IrType $this$isNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isNumber, (String)"$this$isNumber");
        return IrTypePredicatesKt.isNotNullClassType($this$isNumber, StandardNames.FqNames.number);
    }

    public static final boolean isComparable(@NotNull IrType $this$isComparable) {
        Intrinsics.checkNotNullParameter((Object)$this$isComparable, (String)"$this$isComparable");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.comparable.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.comparable.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isComparable, fqNameUnsafe);
    }

    public static final boolean isCharSequence(@NotNull IrType $this$isCharSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharSequence, (String)"$this$isCharSequence");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharSequence, StandardNames.FqNames.charSequence);
    }

    public static final boolean isIterable(@NotNull IrType $this$isIterable) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterable, (String)"$this$isIterable");
        FqNameUnsafe fqNameUnsafe = StandardNames.FqNames.iterable.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.FqNames.iterable.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isIterable, fqNameUnsafe);
    }

    public static final boolean isSequence(@NotNull IrType $this$isSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$isSequence, (String)"$this$isSequence");
        return IrTypePredicatesKt.isNotNullClassType($this$isSequence, new FqNameUnsafe("kotlin.sequences.Sequence"));
    }

    public static final boolean isBooleanArray(@NotNull IrType $this$isBooleanArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBooleanArray, (String)"$this$isBooleanArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isBooleanArray, new FqNameUnsafe("kotlin.BooleanArray"));
    }

    public static final boolean isCharArray(@NotNull IrType $this$isCharArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharArray, (String)"$this$isCharArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharArray, new FqNameUnsafe("kotlin.CharArray"));
    }

    public static final boolean isByteArray(@NotNull IrType $this$isByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isByteArray, (String)"$this$isByteArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isByteArray, new FqNameUnsafe("kotlin.ByteArray"));
    }

    public static final boolean isShortArray(@NotNull IrType $this$isShortArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isShortArray, (String)"$this$isShortArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isShortArray, new FqNameUnsafe("kotlin.ShortArray"));
    }

    public static final boolean isIntArray(@NotNull IrType $this$isIntArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntArray, (String)"$this$isIntArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isIntArray, new FqNameUnsafe("kotlin.IntArray"));
    }

    public static final boolean isLongArray(@NotNull IrType $this$isLongArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isLongArray, (String)"$this$isLongArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isLongArray, new FqNameUnsafe("kotlin.LongArray"));
    }

    public static final boolean isFloatArray(@NotNull IrType $this$isFloatArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isFloatArray, (String)"$this$isFloatArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloatArray, new FqNameUnsafe("kotlin.FloatArray"));
    }

    public static final boolean isDoubleArray(@NotNull IrType $this$isDoubleArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isDoubleArray, (String)"$this$isDoubleArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isDoubleArray, new FqNameUnsafe("kotlin.DoubleArray"));
    }

    public static final boolean isKotlinResult(@NotNull IrType $this$isKotlinResult) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinResult, (String)"$this$isKotlinResult");
        FqNameUnsafe fqNameUnsafe = StandardNames.RESULT_FQ_NAME.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.RESULT_FQ_NAME.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isKotlinResult, fqNameUnsafe);
    }

    public static final boolean isNullableContinuation(@NotNull IrType $this$isNullableContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableContinuation, (String)"$this$isNullableContinuation");
        FqNameUnsafe fqNameUnsafe = StandardNames.CONTINUATION_INTERFACE_FQ_NAME_RELEASE.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"StandardNames.CONTINUATI\u2026Q_NAME_RELEASE.toUnsafe()");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableContinuation, fqNameUnsafe);
    }
}

