/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;

public class DefaultResourceLockCoordinationService
implements ResourceLockCoordinationService {
    private final Object lock = new Object();
    private final ThreadLocal<List<ResourceLockState>> currentState = new ThreadLocal<List<ResourceLockState>>(){

        @Override
        protected List<ResourceLockState> initialValue() {
            return Lists.newArrayList();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean withStateLock(Transformer<ResourceLockState.Disposition, ResourceLockState> stateLockAction) {
        while (true) {
            resourceLockState = new DefaultResourceLockState();
            var4_4 = this.lock;
            synchronized (var4_4) {
                try {
                    this.currentState.get().add(resourceLockState);
                    disposition = stateLockAction.transform(resourceLockState);
                    switch (2.$SwitchMap$org$gradle$internal$resources$ResourceLockState$Disposition[disposition.ordinal()]) {
                        case 1: {
                            resourceLockState.releaseLocks();
                            try {
                                this.lock.wait();
                                ** break;
lbl15:
                                // 1 sources

                                break;
                            }
                            catch (InterruptedException e) {
                                throw UncheckedException.throwAsUncheckedException(e);
                            }
                        }
                        case 2: {
                            this.maybeNotifyStateChange(resourceLockState);
                            e = true;
                            return e;
                        }
                        case 3: {
                            resourceLockState.releaseLocks();
                            e = false;
                            return e;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled disposition type: " + disposition.name());
                        }
                    }
                }
                catch (Throwable t) {
                    resourceLockState.releaseLocks();
                    throw UncheckedException.throwAsUncheckedException(t);
                }
                finally {
                    this.currentState.get().remove(resourceLockState);
                }
            }
        }
    }

    @Override
    public ResourceLockState getCurrent() {
        List<ResourceLockState> current = this.currentState.get();
        if (!current.isEmpty()) {
            int numStates = current.size();
            return current.get(numStates - 1);
        }
        return null;
    }

    private void maybeNotifyStateChange(DefaultResourceLockState resourceLockState) {
        if (resourceLockState.hasUnlockedResources()) {
            this.notifyStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStateChange() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> lock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, true);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> lock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.lock(Arrays.asList(resourceLocks));
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> tryLock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, false);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> tryLock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.tryLock(Arrays.asList(resourceLocks));
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> unlock(Iterable<? extends ResourceLock> resourceLocks) {
        return new ReleaseLocks(resourceLocks);
    }

    public static Transformer<ResourceLockState.Disposition, ResourceLockState> unlock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.unlock(Arrays.asList(resourceLocks));
    }

    private static class ReleaseLocks
    implements Transformer<ResourceLockState.Disposition, ResourceLockState> {
        private final Iterable<? extends ResourceLock> resourceLocks;

        ReleaseLocks(Iterable<? extends ResourceLock> resourceLocks) {
            this.resourceLocks = resourceLocks;
        }

        @Override
        public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                resourceLock.unlock();
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }

    private static class AcquireLocks
    implements Transformer<ResourceLockState.Disposition, ResourceLockState> {
        private final Iterable<? extends ResourceLock> resourceLocks;
        private final boolean blocking;

        AcquireLocks(Iterable<? extends ResourceLock> resourceLocks, boolean blocking) {
            this.resourceLocks = resourceLocks;
            this.blocking = blocking;
        }

        @Override
        public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                if (resourceLock.tryLock()) continue;
                return this.blocking ? ResourceLockState.Disposition.RETRY : ResourceLockState.Disposition.FAILED;
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }

    private static class DefaultResourceLockState
    implements ResourceLockState {
        private Set<ResourceLock> lockedResources;
        private Set<ResourceLock> unlockedResources;
        boolean rollback;

        private DefaultResourceLockState() {
        }

        @Override
        public void registerLocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.unlockedResources != null && this.unlockedResources.remove(resourceLock))) {
                if (this.lockedResources == null) {
                    this.lockedResources = Sets.newHashSet();
                }
                this.lockedResources.add(resourceLock);
            }
        }

        @Override
        public void registerUnlocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.lockedResources != null && this.lockedResources.remove(resourceLock))) {
                if (this.unlockedResources == null) {
                    this.unlockedResources = Sets.newHashSet();
                }
                this.unlockedResources.add(resourceLock);
            }
        }

        boolean hasUnlockedResources() {
            return this.unlockedResources != null && !this.unlockedResources.isEmpty();
        }

        @Override
        public void releaseLocks() {
            if (this.lockedResources != null) {
                this.rollback = true;
                try {
                    for (ResourceLock resourceLock : this.lockedResources) {
                        resourceLock.unlock();
                    }
                    this.lockedResources.clear();
                }
                finally {
                    this.rollback = false;
                }
            }
        }
    }
}

