/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

public class IsolatedClassloaderWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ServiceRegistry internalServices;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final LegacyTypesSupport legacyTypesSupport;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final InstantiatorFactory instantiatorFactory;

    public IsolatedClassloaderWorkerFactory(BuildOperationExecutor buildOperationExecutor, ServiceRegistry internalServices, ClassLoaderRegistry classLoaderRegistry, LegacyTypesSupport legacyTypesSupport, ActionExecutionSpecFactory actionExecutionSpecFactory, InstantiatorFactory instantiatorFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.internalServices = internalServices;
        this.classLoaderRegistry = classLoaderRegistry;
        this.legacyTypesSupport = legacyTypesSupport;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public BuildOperationAwareWorker getWorker(final WorkerRequirement workerRequirement) {
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(IsolatedParametersActionExecutionSpec<?> spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, workSpec -> {
                    TransportableActionExecutionSpec transportableSpec = IsolatedClassloaderWorkerFactory.this.actionExecutionSpecFactory.newTransportableSpec(spec);
                    ClassLoader workerInfrastructureClassloader = IsolatedClassloaderWorkerFactory.this.classLoaderRegistry.getPluginsClassLoader();
                    ClassLoaderStructure classLoaderStructure = ((IsolatedClassLoaderWorkerRequirement)workerRequirement).getClassLoaderStructure();
                    ClassLoader workerClassLoader = IsolatedClassloaderWorker.createIsolatedWorkerClassloader(classLoaderStructure, workerInfrastructureClassloader, IsolatedClassloaderWorkerFactory.this.legacyTypesSupport);
                    IsolatedClassloaderWorker worker = new IsolatedClassloaderWorker(workerClassLoader, IsolatedClassloaderWorkerFactory.this.internalServices, IsolatedClassloaderWorkerFactory.this.actionExecutionSpecFactory, IsolatedClassloaderWorkerFactory.this.instantiatorFactory);
                    return (DefaultWorkResult)worker.run(transportableSpec);
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.CLASSLOADER;
    }
}

