/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexedFile;
import org.jetbrains.kotlin.com.intellij.util.indexing.SubstitutedFileType;

@ApiStatus.Internal
public class IndexedFileImpl
extends UserDataHolderBase
implements IndexedFile {
    protected final VirtualFile myFile;
    protected final String myFileName;
    protected final FileType myFileType;
    private volatile Project myProject;

    public IndexedFileImpl(@NotNull VirtualFile file2, @NotNull FileType type2, Project project) {
        if (file2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(2);
        }
        this.myFile = file2;
        this.myFileName = file2.getName();
        this.myFileType = type2;
        this.myProject = project;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = SubstitutedFileType.substituteFileType(this.myFile, this.myFileType, this.getProject());
        if (fileType == null) {
            IndexedFileImpl.$$$reportNull$$$0(3);
        }
        return fileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string2 = this.myFileName;
        if (string2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@NotNull Project project) {
        if (project == null) {
            IndexedFileImpl.$$$reportNull$$$0(6);
        }
        this.myProject = project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

