/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.InlinerCycleReporter$WhenMappings;
import org.jetbrains.kotlin.js.inline.JsCallInfo;
import org.jetbrains.kotlin.js.inline.context.FunctionDefinitionLoader;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cJ\u001a\u0010\u001d\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\bH\u0002J'\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0\u001c\u00a2\u0006\u0002\u0010#R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "functionDefinitionLoader", "Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;)V", "currentNamedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "getCurrentNamedFunction", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionVisitingState", "", "Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter$VisitedState;", "inlineCallInfos", "Ljava/util/LinkedList;", "Lorg/jetbrains/kotlin/js/inline/JsCallInfo;", "namedFunctionsStack", "Ljava/util/Stack;", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "processInlineFunction", "", "definition", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "doProcess", "Lkotlin/Function0;", "reportInlineCycle", "calledFunction", "withFunction", "T", "function", "body", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "VisitedState", "js.translator"})
public final class InlinerCycleReporter {
    private final Map<JsFunction, VisitedState> functionVisitingState;
    private final Stack<JsFunction> namedFunctionsStack;
    private final LinkedList<JsCallInfo> inlineCallInfos;
    private final DiagnosticSink trace;
    private final FunctionDefinitionLoader functionDefinitionLoader;

    private final JsFunction getCurrentNamedFunction() {
        return this.namedFunctionsStack.empty() ? null : this.namedFunctionsStack.peek();
    }

    public final <T> T withFunction(@NotNull JsFunction function2, @NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        if (this.functionDefinitionLoader.getFunctionsByFunctionNodes().keySet().contains(function2)) {
            this.namedFunctionsStack.push(function2);
        }
        Object result2 = body2.invoke();
        if (Intrinsics.areEqual((Object)this.getCurrentNamedFunction(), (Object)function2)) {
            this.namedFunctionsStack.pop();
        }
        return (T)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processInlineFunction(@NotNull FunctionWithWrapper definition, @Nullable JsInvocation call2, @NotNull Function0<Unit> doProcess) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(doProcess, (String)"doProcess");
        JsFunction function2 = definition.getFunction();
        if (call2 != null) {
            JsFunction jsFunction = this.getCurrentNamedFunction();
            if (jsFunction != null) {
                JsFunction jsFunction2 = jsFunction;
                boolean bl = false;
                boolean bl2 = false;
                JsFunction it = jsFunction2;
                boolean bl3 = false;
                this.inlineCallInfos.add(new JsCallInfo(call2, it));
            }
        }
        try {
            VisitedState visitedState = this.functionVisitingState.get(definition.getFunction());
            if (visitedState != null) {
                switch (InlinerCycleReporter$WhenMappings.$EnumSwitchMapping$0[visitedState.ordinal()]) {
                    case 1: {
                        this.reportInlineCycle(call2, definition.getFunction());
                        return;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            this.functionVisitingState.put(function2, VisitedState.IN_PROCESS);
            this.withFunction(function2, doProcess);
            this.functionVisitingState.put(function2, VisitedState.PROCESSED);
        }
        finally {
            if (!this.inlineCallInfos.isEmpty() && Intrinsics.areEqual((Object)this.inlineCallInfos.getLast().getCall(), (Object)call2)) {
                this.inlineCallInfos.removeLast();
            }
        }
    }

    private final void reportInlineCycle(JsInvocation call2, JsFunction calledFunction) {
        JsInvocation jsInvocation = call2;
        if (jsInvocation != null) {
            MetadataProperties.setInline(jsInvocation, (Boolean)false);
        }
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataProperties.getPsiElement(callInfo.getCall());
            CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(callInfo.getCall());
            if (psiElement != null && descriptor2 != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement, descriptor2));
            }
            if (!Intrinsics.areEqual((Object)callInfo.getContainingFunction(), (Object)calledFunction)) continue;
            break;
        }
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    public InlinerCycleReporter(@NotNull DiagnosticSink trace, @NotNull FunctionDefinitionLoader functionDefinitionLoader) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)functionDefinitionLoader, (String)"functionDefinitionLoader");
        this.trace = trace;
        this.functionDefinitionLoader = functionDefinitionLoader;
        boolean bl = false;
        this.functionVisitingState = new LinkedHashMap();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter$VisitedState;", "", "(Ljava/lang/String;I)V", "IN_PROCESS", "PROCESSED", "js.translator"})
    private static final class VisitedState
    extends Enum<VisitedState> {
        public static final /* enum */ VisitedState IN_PROCESS;
        public static final /* enum */ VisitedState PROCESSED;
        private static final /* synthetic */ VisitedState[] $VALUES;

        static {
            VisitedState[] visitedStateArray = new VisitedState[2];
            VisitedState[] visitedStateArray2 = visitedStateArray;
            visitedStateArray[0] = IN_PROCESS = new VisitedState();
            visitedStateArray[1] = PROCESSED = new VisitedState();
            $VALUES = visitedStateArray;
        }

        public static VisitedState[] values() {
            return (VisitedState[])$VALUES.clone();
        }

        public static VisitedState valueOf(String string2) {
            return Enum.valueOf(VisitedState.class, string2);
        }
    }
}

