/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.TreeSet;
import org.gradle.api.Describable;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.util.internal.VersionNumber;

public class UpgradeCapabilityResolver
implements CapabilitiesConflictHandler.Resolver {
    @Override
    public void resolve(CapabilitiesConflictHandler.ResolutionDetails details) {
        Collection<? extends Capability> capabilityVersions = details.getCapabilityVersions();
        if (capabilityVersions.size() > 1) {
            TreeSet sorted = Sets.newTreeSet((o1, o2) -> {
                VersionNumber v1 = VersionNumber.parse((String)o1.getVersion());
                VersionNumber v2 = VersionNumber.parse((String)o2.getVersion());
                return v2.compareTo(v1);
            });
            sorted.addAll(capabilityVersions);
            boolean first = true;
            for (Capability capability : sorted) {
                DisplayName reason = Describables.of((Object)"latest version of capability", (Object)((CapabilityInternal)capability).getCapabilityId());
                boolean isFirst = first;
                details.getCandidates(capability).forEach(cand -> {
                    cand.byReason((Describable)reason);
                    if (!isFirst) {
                        cand.evict();
                    }
                });
                first = false;
            }
        }
    }
}

