/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.mvnsettings;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.api.internal.artifacts.mvnsettings.CannotLocateLocalMavenRepositoryException;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalMavenRepositoryLocator
implements LocalMavenRepositoryLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalMavenRepositoryLocator.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^}]*)}");
    private final MavenSettingsProvider settingsProvider;
    private final SystemPropertyAccess system;
    private String localRepoPathFromMavenSettings;

    public DefaultLocalMavenRepositoryLocator(MavenSettingsProvider settingsProvider) {
        this(settingsProvider, new CurrentSystemPropertyAccess());
    }

    protected DefaultLocalMavenRepositoryLocator(MavenSettingsProvider settingsProvider, SystemPropertyAccess system) {
        this.settingsProvider = settingsProvider;
        this.system = system;
    }

    @Override
    public File getLocalMavenRepository() throws CannotLocateLocalMavenRepositoryException {
        String localOverride = this.system.getProperty("maven.repo.local");
        if (localOverride != null) {
            return new File(localOverride);
        }
        try {
            String repoPath = this.parseLocalRepoPathFromMavenSettings();
            if (repoPath != null) {
                File file = new File(this.resolvePlaceholders(repoPath.trim()));
                if (this.isDriveRelativeWindowsPath(file)) {
                    return file.getAbsoluteFile();
                }
                return file;
            }
            File defaultLocation = new File(this.system.getProperty("user.home"), "/.m2/repository").getAbsoluteFile();
            LOGGER.debug("No local repository in Settings file defined. Using default path: {}", (Object)defaultLocation);
            return defaultLocation;
        }
        catch (SettingsBuildingException e) {
            throw new CannotLocateLocalMavenRepositoryException("Unable to parse local Maven settings.", e);
        }
    }

    private boolean isDriveRelativeWindowsPath(File file) {
        return !file.isAbsolute() && file.getPath().startsWith(File.separator);
    }

    private synchronized String parseLocalRepoPathFromMavenSettings() throws SettingsBuildingException {
        if (this.localRepoPathFromMavenSettings == null) {
            this.localRepoPathFromMavenSettings = this.settingsProvider.getLocalRepository();
        }
        return this.localRepoPathFromMavenSettings;
    }

    private String resolvePlaceholders(String value) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        while (matcher.find()) {
            String replacement;
            String placeholder = matcher.group(1);
            String string = replacement = placeholder.startsWith("env.") ? this.system.getEnv(placeholder.substring(4)) : this.system.getProperty(placeholder);
            if (replacement == null) {
                throw new CannotLocateLocalMavenRepositoryException(String.format("Cannot resolve placeholder '%s' in value '%s'", placeholder, value));
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static class CurrentSystemPropertyAccess
    implements SystemPropertyAccess {
        @Override
        public String getProperty(String name) {
            return System.getProperty(name);
        }

        @Override
        public String getEnv(String name) {
            return System.getenv(name);
        }
    }

    public static interface SystemPropertyAccess {
        public String getProperty(String var1);

        public String getEnv(String var1);
    }
}

