/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceServices;
import org.gradle.api.provider.Provider;
import org.gradle.cache.Cache;
import org.gradle.cache.ManualEvictionInMemoryCache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.ReservedFileSystemLocation;

@NotThreadSafe
public class MutableTransformationWorkspaceServices
implements TransformationWorkspaceServices,
ReservedFileSystemLocation {
    private final Cache<UnitOfWork.Identity, Try<TransformationResult>> identityCache = new ManualEvictionInMemoryCache();
    private final Provider<Directory> baseDirectory;
    private final WorkspaceProvider workspaceProvider;
    private final ExecutionHistoryStore executionHistoryStore;

    public MutableTransformationWorkspaceServices(Provider<Directory> baseDirectory, ExecutionHistoryStore executionHistoryStore) {
        this.baseDirectory = baseDirectory;
        this.workspaceProvider = new MutableTransformationWorkspaceProvider();
        this.executionHistoryStore = executionHistoryStore;
    }

    @Override
    public WorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    @Override
    public Cache<UnitOfWork.Identity, Try<TransformationResult>> getIdentityCache() {
        return this.identityCache;
    }

    public Provider<? extends FileSystemLocation> getReservedFileSystemLocation() {
        return this.baseDirectory;
    }

    private class MutableTransformationWorkspaceProvider
    implements WorkspaceProvider {
        private MutableTransformationWorkspaceProvider() {
        }

        public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
            File workspaceDir = new File(((Directory)MutableTransformationWorkspaceServices.this.baseDirectory.get()).getAsFile(), path);
            return (T)action.executeInWorkspace(workspaceDir, MutableTransformationWorkspaceServices.this.executionHistoryStore);
        }
    }
}

