/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;

public abstract class TransformationSubject
implements Describable {
    public static TransformationSubject initial(ResolvableArtifact artifact) {
        return new InitialArtifactTransformationSubject(artifact);
    }

    public abstract ImmutableList<File> getFiles();

    public abstract ComponentIdentifier getInitialComponentIdentifier();

    public TransformationSubject createSubjectFromResult(ImmutableList<File> result) {
        return new SubsequentTransformationSubject(this, result);
    }

    private static class SubsequentTransformationSubject
    extends TransformationSubject {
        private final TransformationSubject previous;
        private final ImmutableList<File> files;

        public SubsequentTransformationSubject(TransformationSubject previous, ImmutableList<File> files) {
            this.previous = previous;
            this.files = files;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return this.files;
        }

        @Override
        public ComponentIdentifier getInitialComponentIdentifier() {
            return this.previous.getInitialComponentIdentifier();
        }

        public String getDisplayName() {
            return this.previous.getDisplayName();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private static class InitialArtifactTransformationSubject
    extends TransformationSubject {
        private final ResolvableArtifact artifact;

        public InitialArtifactTransformationSubject(ResolvableArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public ImmutableList<File> getFiles() {
            return ImmutableList.of((Object)this.artifact.getFile());
        }

        public String getDisplayName() {
            return this.artifact.getId().getDisplayName();
        }

        @Override
        public ComponentIdentifier getInitialComponentIdentifier() {
            return this.artifact.getId().getComponentIdentifier();
        }
    }
}

