/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.catalog.AbstractProjectAccessorsSourceGenerator;

public class RootProjectAccessorSourceGenerator
extends AbstractProjectAccessorsSourceGenerator {
    public static final String ROOT_PROJECT_ACCESSOR_CLASSNAME = "RootProjectAccessor";

    public RootProjectAccessorSourceGenerator(Writer writer) {
        super(writer);
    }

    public static void generateSource(Writer writer, ProjectDescriptor root, String packageName) {
        RootProjectAccessorSourceGenerator generator = new RootProjectAccessorSourceGenerator(writer);
        try {
            generator.generate(packageName, ROOT_PROJECT_ACCESSOR_CLASSNAME, root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void generate(String packageName, String className, ProjectDescriptor current) throws IOException {
        this.writeHeader(packageName);
        this.writeLn("@NonNullApi");
        this.writeLn("public class " + className + " extends TypeSafeProjectDependencyFactory {\n");
        this.writeLn();
        this.writeLn("    @Inject");
        this.writeLn("    public " + className + "(DefaultProjectDependencyFactory factory, ProjectFinder finder) {");
        this.writeLn("        super(factory, finder);");
        this.writeLn("    }");
        this.writeLn();
        this.writeProjectAccessor(RootProjectAccessorSourceGenerator.toJavaName(RootProjectAccessorSourceGenerator.rootProjectName(current)), current);
        this.processChildren(current);
        this.writeLn("}");
    }
}

