/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.AbstractIncludedBuildController;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultIncludedBuildController
extends AbstractIncludedBuildController {
    private final IncludedBuildState includedBuild;
    private final ProjectStateRegistry projectStateRegistry;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final WorkerLeaseService workerLeaseService;
    private final Lock lock = new ReentrantLock();
    private final Condition stateChange = this.lock.newCondition();
    private boolean finished;
    private final List<Throwable> executionFailures = new ArrayList<Throwable>();

    public DefaultIncludedBuildController(IncludedBuildState includedBuild, ProjectStateRegistry projectStateRegistry, WorkerLeaseService workerLeaseService) {
        super((CompositeBuildParticipantBuildState)includedBuild);
        this.includedBuild = includedBuild;
        this.projectStateRegistry = projectStateRegistry;
        this.parentLease = workerLeaseService.getCurrentWorkerLease();
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    protected void doStartTaskExecution(ExecutorService executorService) {
        executorService.submit(new BuildOpRunnable(CurrentBuildOperationRef.instance().get()));
    }

    @Override
    protected void doAwaitTaskCompletion(Consumer<? super Throwable> executionFailures) {
        this.projectStateRegistry.blocking(() -> {
            this.lock.lock();
            try {
                while (!this.finished) {
                    this.awaitStateChange();
                }
                for (Throwable taskFailure : this.executionFailures) {
                    executionFailures.accept(taskFailure);
                }
                this.executionFailures.clear();
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    private void run() {
        try {
            this.workerLeaseService.withSharedLease(this.parentLease, this::doBuild);
        }
        catch (Throwable t) {
            this.executionFailed(t);
        }
        finally {
            this.markFinished();
        }
    }

    private void markFinished() {
        this.lock.lock();
        try {
            this.finished = true;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitStateChange() {
        try {
            this.stateChange.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void doBuild() {
        ExecutionResult result = this.includedBuild.getWorkGraph().execute();
        this.executionFinished((ExecutionResult<Void>)result);
    }

    private void executionFinished(ExecutionResult<Void> result) {
        this.lock.lock();
        try {
            this.executionFailures.addAll(result.getFailures());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executionFailed(Throwable failure) {
        this.lock.lock();
        try {
            this.executionFailures.add(failure);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class BuildOpRunnable
    implements Runnable {
        private final BuildOperationRef parentBuildOperation;

        BuildOpRunnable(BuildOperationRef parentBuildOperation) {
            this.parentBuildOperation = parentBuildOperation;
        }

        @Override
        public void run() {
            CurrentBuildOperationRef.instance().set(this.parentBuildOperation);
            try {
                DefaultIncludedBuildController.this.run();
            }
            finally {
                CurrentBuildOperationRef.instance().set(null);
            }
        }
    }
}

