/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.util.Path;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild,
Stoppable {
    private final Path identityPath;
    private final BuildState owner;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeLifecycleController buildTreeLifecycleController;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner, BuildTreeState buildTree, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ProjectStateRegistry projectStateRegistry) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.owner = owner;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, (BuildState)this, owner, buildScopeServices);
        IncludedBuildTaskGraph taskGraph = (IncludedBuildTaskGraph)buildScopeServices.get(IncludedBuildTaskGraph.class);
        ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)buildScopeServices.get(ExceptionAnalyser.class);
        BuildModelParameters modelParameters = (BuildModelParameters)buildScopeServices.get(BuildModelParameters.class);
        DefaultBuildTreeWorkExecutor workExecutor = new DefaultBuildTreeWorkExecutor(taskGraph, this.buildLifecycleController);
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = (BuildTreeLifecycleControllerFactory)buildScopeServices.get(BuildTreeLifecycleControllerFactory.class);
        Object finishExecutor = modelParameters.isRequiresBuildModel() ? new DoNothingBuildFinishExecutor(exceptionAnalyser) : new FinishThisBuildOnlyFinishExecutor(exceptionAnalyser);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(this.buildLifecycleController, (BuildTreeWorkExecutor)workExecutor, (BuildTreeFinishExecutor)finishExecutor);
    }

    protected BuildLifecycleController getBuildController() {
        return this.buildLifecycleController;
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return true;
    }

    public void stop() {
        this.buildLifecycleController.stop();
    }

    public ExecutionResult<Void> finishBuild() {
        return this.buildLifecycleController.finishBuild(null);
    }

    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        return buildAction.apply((BuildTreeLifecycleController)this.buildTreeLifecycleController);
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildDefinition.getName());
    }

    public Path calculateIdentityPathForProject(Path projectPath) {
        return this.buildLifecycleController.getGradle().getIdentityPath().append(projectPath);
    }

    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }

    private class FinishThisBuildOnlyFinishExecutor
    implements BuildTreeFinishExecutor {
        private final ExceptionAnalyser exceptionAnalyser;

        public FinishThisBuildOnlyFinishExecutor(ExceptionAnalyser exceptionAnalyser) {
            this.exceptionAnalyser = exceptionAnalyser;
        }

        @Nullable
        public RuntimeException finishBuildTree(List<Throwable> failures) {
            RuntimeException reportable = this.exceptionAnalyser.transform(failures);
            ExecutionResult finishResult = DefaultNestedBuild.this.buildLifecycleController.finishBuild((Throwable)reportable);
            return this.exceptionAnalyser.transform(ExecutionResult.maybeFailed((Throwable)reportable).withFailures(finishResult).getFailures());
        }
    }

    private static class DoNothingBuildFinishExecutor
    implements BuildTreeFinishExecutor {
        private final ExceptionAnalyser exceptionAnalyser;

        public DoNothingBuildFinishExecutor(ExceptionAnalyser exceptionAnalyser) {
            this.exceptionAnalyser = exceptionAnalyser;
        }

        @Nullable
        public RuntimeException finishBuildTree(List<Throwable> failures) {
            return this.exceptionAnalyser.transform(failures);
        }
    }
}

