/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.function.Function;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.internal.build.BuildLayoutValidator;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.NestedBuildTree;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.time.Time;
import org.gradle.util.Path;

public class DefaultNestedBuildTree
implements NestedBuildTree {
    private final BuildDefinition buildDefinition;
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildState owner;
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionState crossBuildSessionState;
    private final BuildCancellationToken buildCancellationToken;

    public DefaultNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner, GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionState crossBuildSessionState, BuildCancellationToken buildCancellationToken) {
        this.buildDefinition = buildDefinition;
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.owner = owner;
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionState = crossBuildSessionState;
        this.buildCancellationToken = buildCancellationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        StartParameterInternal startParameter = this.buildDefinition.getStartParameter();
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        try (BuildSessionState session = new BuildSessionState(this.userHomeDirServiceRegistry, this.crossBuildSessionState, startParameter, (BuildRequestMetaData)buildRequestMetaData, ClassPath.EMPTY, this.buildCancellationToken, buildRequestMetaData.getClient(), (BuildEventConsumer)new NoOpBuildEventConsumer());){
            ((BuildLayoutValidator)session.getServices().get(BuildLayoutValidator.class)).validate(startParameter);
            RootOfNestedBuildTree buildTree = new RootOfNestedBuildTree(this.buildDefinition, this.buildIdentifier, this.identityPath, this.owner, session);
            buildTree.attach();
            T t = buildTree.run(buildAction);
            return t;
        }
    }
}

