/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.api.internal.GradleInternal;
import org.gradle.cache.scopes.BuildScopedCache;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class ResolvedBuildLayout {
    private final GradleInternal gradle;
    private final BuildLayout buildLayout;
    private final BuildScopedCache buildScopedCache;

    public ResolvedBuildLayout(GradleInternal gradle, BuildLayout buildLayout, BuildScopedCache buildScopedCache) {
        this.gradle = gradle;
        this.buildLayout = buildLayout;
        this.buildScopedCache = buildScopedCache;
    }

    public File getCurrentDirectory() {
        return this.gradle.getStartParameter().getCurrentDir();
    }

    public File getGlobalScopeCacheDirectory() {
        return this.gradle.getGradleUserHomeDir();
    }

    public File getBuildScopeCacheDirectory() {
        return this.buildScopedCache.getRootDir();
    }

    public boolean isBuildDefinitionMissing() {
        boolean isNoBuildDefinitionFound = this.buildLayout.isBuildDefinitionMissing();
        boolean isCurrentDirNotPartOfContainingBuild = this.gradle.getSettings().getSettingsScript().getResource().getLocation().getFile() == null;
        return isNoBuildDefinitionFound || isCurrentDirNotPartOfContainingBuild;
    }
}

