/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOutputCleanupRegistry
implements BuildOutputCleanupRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOutputCleanupRegistry.class);
    private final FileCollectionFactory fileCollectionFactory;
    private final Set<FileCollection> outputs = Sets.newHashSet();
    private Set<String> resolvedPaths;

    public DefaultBuildOutputCleanupRegistry(FileCollectionFactory fileCollectionFactory) {
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public void registerOutputs(Object files) {
        if (this.resolvedPaths != null) {
            LOGGER.debug("More outputs are being registered even though the build output cleanup registry has already been finalized. New outputs: {}", files);
        } else {
            this.outputs.add((FileCollection)this.fileCollectionFactory.resolving(files));
        }
    }

    public boolean isOutputOwnedByBuild(File file) {
        Set<String> safeToDelete = this.getResolvedPaths();
        for (File absoluteFile = file.getAbsoluteFile(); absoluteFile != null; absoluteFile = absoluteFile.getParentFile()) {
            if (!safeToDelete.contains(absoluteFile.getPath())) continue;
            return true;
        }
        return false;
    }

    public void resolveOutputs() {
        if (this.resolvedPaths == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (FileCollection output : this.outputs) {
                for (File file : output) {
                    result.add(file.getAbsolutePath());
                }
            }
            this.resolvedPaths = result;
        }
    }

    public Set<FileCollection> getRegisteredOutputs() {
        return this.outputs;
    }

    private Set<String> getResolvedPaths() {
        if (this.resolvedPaths == null) {
            throw new GradleException("Build outputs have not been resolved yet");
        }
        return this.resolvedPaths;
    }
}

