/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.reflect.Instantiator;

public class DefaultBuildIncluder
implements BuildIncluder {
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;
    private final List<BuildDefinition> pluginBuildDefinitions = new ArrayList<BuildDefinition>();

    public DefaultBuildIncluder(BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath, Instantiator instantiator) {
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator;
    }

    @Override
    public IncludedBuildState includeBuild(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        return this.buildRegistry.addIncludedBuild(this.toBuildDefinition(includedBuildSpec, gradle));
    }

    @Override
    public void registerPluginBuild(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        this.pluginBuildDefinitions.add(this.toBuildDefinition(includedBuildSpec, gradle));
    }

    @Override
    public Collection<IncludedBuildState> includeRegisteredPluginBuilds() {
        return this.pluginBuildDefinitions.stream().map(this.buildRegistry::addIncludedBuild).collect(Collectors.toList());
    }

    private BuildDefinition toBuildDefinition(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        gradle.getOwner().assertCanAdd(includedBuildSpec);
        return includedBuildSpec.toBuildDefinition(gradle.getStartParameter(), this.publicBuildPath, this.instantiator);
    }
}

