/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.CrossFileCallAdjuster;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PerformByIrFileKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B-\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u000e\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u000f0\r0\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J3\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeCompilerPhase;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "lower", "", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "copyBeforeLowering", "", "(Ljava/util/List;Z)V", "getNamedSubphases", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "startDepth", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "invokeParallel", "nThreads", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;I)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "invokeSequential", "ir.backend.common"})
final class PerformByIrFilePhase<Context extends CommonBackendContext>
implements SameTypeCompilerPhase<Context, IrModuleFragment> {
    @NotNull
    private final List<CompilerPhase<Context, IrFile, IrFile>> lower;
    private final boolean copyBeforeLowering;

    public PerformByIrFilePhase(@NotNull List<? extends CompilerPhase<? super Context, IrFile, IrFile>> lower2, boolean copyBeforeLowering) {
        Intrinsics.checkNotNullParameter(lower2, (String)"lower");
        this.lower = lower2;
        this.copyBeforeLowering = copyBeforeLowering;
    }

    @Override
    @NotNull
    public IrModuleFragment invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState<IrModuleFragment> phaserState, @NotNull Context context2, @NotNull IrModuleFragment input) {
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Integer n = context2.getConfiguration().get(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS);
        Integer n2 = n == null ? Integer.valueOf(1) : n;
        int nThreads = ((Number)n2).intValue();
        return nThreads > 1 ? this.invokeParallel(phaseConfig, phaserState, context2, input, nThreads) : this.invokeSequential(phaseConfig, phaserState, context2, input);
    }

    private final IrModuleFragment invokeSequential(PhaseConfig phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context2, IrModuleFragment input) {
        for (IrFile irFile : input.getFiles()) {
            try {
                PhaserState filePhaserState = CompilerPhaseKt.changeType(phaserState);
                for (CompilerPhase<Context, IrFile, IrFile> phase : this.lower) {
                    phase.invoke(phaseConfig, filePhaserState, context2, irFile);
                }
            }
            catch (Throwable e) {
                CodegenUtil.reportBackendException$default(e, "IR lowering", irFile.getFileEntry().getName(), null, 8, null);
                throw null;
            }
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private final IrModuleFragment invokeParallel(PhaseConfig phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context2, IrModuleFragment input, int nThreads) {
        IrFile irFile3;
        Object object;
        List<IrFile> list2;
        Pair $this$mapTo$iv$iv2;
        if (input.getFiles().isEmpty()) {
            return input;
        }
        AtomicReference<Object> thrownFromThread = new AtomicReference<Object>(null);
        boolean bl = false;
        Map remappedFiles = new LinkedHashMap();
        boolean bl2 = false;
        Map remappedFunctions = new LinkedHashMap();
        boolean bl3 = false;
        Map remappedClasses = new LinkedHashMap();
        Iterable $this$map$iv = input.getFiles();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        List<IrFile> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrFile irFile2 = (IrFile)item$iv$iv;
            list2 = destination$iv$iv;
            boolean bl4 = false;
            object = this.copyBeforeLowering ? TuplesKt.to((Object)PerformByIrFileKt.copySavingMappings((IrFile)it, remappedFiles, remappedFunctions, remappedClasses), phaserState.copyOf()) : TuplesKt.to((Object)it, phaserState.copyOf());
            list2.add((IrFile)object);
        }
        List filesAndStates = destination$iv$iv;
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        for (Pair $this$mapTo$iv$iv2 : filesAndStates) {
            irFile3 = (IrFile)$this$mapTo$iv$iv2.component1();
            PhaserState state = (PhaserState)$this$mapTo$iv$iv2.component2();
            executor.execute(() -> PerformByIrFilePhase.invokeParallel$lambda-1(state, this, phaseConfig, context2, irFile3, thrownFromThread));
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        Object $i$f$map22 = thrownFromThread.get();
        if ($i$f$map22 != null) {
            $this$mapTo$iv$iv2 = $i$f$map22;
            boolean irFile3 = false;
            boolean state = false;
            Pair $dstr$e$irFile = $this$mapTo$iv$iv2;
            boolean bl5 = false;
            Throwable e = (Throwable)$dstr$e$irFile.component1();
            IrFile irFile4 = (IrFile)$dstr$e$irFile.component2();
            CodegenUtil.reportBackendException$default(e, "Experimental parallel IR backend", irFile4.getFileEntry().getName(), null, 8, null);
            throw null;
        }
        phaserState.getAlreadyDone().addAll((Collection)((PhaserState)((Pair)filesAndStates.get(0)).getSecond()).getAlreadyDone());
        if (this.copyBeforeLowering) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            input.getFiles().clear();
            $i$f$map22 = filesAndStates;
            list2 = input.getFiles();
            boolean $i$f$map = false;
            irFile3 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void $dstr$irFile$_u24__u24;
                IrFile irFile5;
                Pair irFile4 = (Pair)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl6 = false;
                IrFile irFile6 = irFile5 = (IrFile)$dstr$irFile$_u24__u24.component1();
                object.add(irFile6);
            }
            object = (List)destination$iv$iv2;
            list2.addAll(CollectionsKt.toMutableList((Collection)((Collection)object)));
            PerformByIrFileKt.access$adjustDefaultArgumentStubs(context2, remappedFunctions);
            context2.handleDeepCopy(remappedFiles, remappedClasses, remappedFunctions);
            IrElementTransformerVoidKt.transformChildrenVoid(input, new CrossFileCallAdjuster(remappedFunctions));
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<Context, ?>>> getNamedSubphases(int startDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.lower;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNamedSubphases(startDepth);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Set<Function1<IrModuleFragment, Unit>> getStickyPostconditions() {
        return SameTypeCompilerPhase.DefaultImpls.getStickyPostconditions(this);
    }

    private static final void invokeParallel$lambda-1(PhaserState $state, PerformByIrFilePhase this$0, PhaseConfig $phaseConfig, CommonBackendContext $context, IrFile $irFile, AtomicReference $thrownFromThread) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$phaseConfig, (String)"$phaseConfig");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$irFile, (String)"$irFile");
        Intrinsics.checkNotNullParameter((Object)$thrownFromThread, (String)"$thrownFromThread");
        try {
            PhaserState filePhaserState = CompilerPhaseKt.changeType($state);
            for (CompilerPhase<CommonBackendContext, IrFile, IrFile> compilerPhase : this$0.lower) {
                compilerPhase.invoke($phaseConfig, filePhaserState, $context, $irFile);
            }
        }
        catch (Throwable e) {
            $thrownFromThread.set(new Pair((Object)e, (Object)$irFile));
        }
    }
}

