/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.BooleanStack;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(DefaultStubBuilder.class);

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(0);
        }
        return this.buildStubTreeFor(file2.getNode(), this.createStubForFile(file2));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2) {
        PsiFileStubImpl<PsiFile> stub;
        if (file2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(1);
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            DefaultStubBuilder.$$$reportNull$$$0(2);
        }
        return psiFileStubImpl;
    }

    @NotNull
    protected final StubElement buildStubTreeFor(@NotNull ASTNode root2, @NotNull StubElement parentStub) {
        if (root2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            DefaultStubBuilder.$$$reportNull$$$0(4);
        }
        new StubBuildingWalkingVisitor(root2, parentStub).buildStubTree();
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            DefaultStubBuilder.$$$reportNull$$$0(5);
        }
        return stubElement;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        if (parent2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DefaultStubBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubTreeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTreeFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected class StubBuildingWalkingVisitor {
        private final Stack<StubElement> parentStubs = new Stack();
        private final Stack<ASTNode> parentNodes = new Stack();
        private final BooleanStack parentNodesStubbed = new BooleanStack();

        protected StubBuildingWalkingVisitor(ASTNode root2, StubElement parentStub) {
            this.parentNodes.push(root2);
            this.parentStubs.push(parentStub);
            this.parentNodesStubbed.push(true);
        }

        public final void buildStubTree() {
            while (!this.parentStubs.isEmpty()) {
                this.visitNode(this.parentStubs.pop(), this.parentNodes.pop(), this.parentNodesStubbed.pop());
            }
        }

        protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
            StubElement stub = this.createStub(parentStub, node);
            if (stub != null && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            this.pushChildren(node, node instanceof FileElement || stub != null, stub != null ? stub : parentStub);
        }

        @Nullable
        protected final ASTNode peekNextElement() {
            return this.parentNodes.isEmpty() ? null : this.parentNodes.peek();
        }

        @Nullable
        protected StubElement createStub(StubElement parentStub, ASTNode node) {
            IStubElementType type2;
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type2 = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type2 + ", PSI: " + element + ", language: #" + type2.getLanguage());
                }
                Object stub = type2.createStub(element, parentStub);
                LOG.assertTrue(stub != null, element);
                return stub;
            }
            return null;
        }

        private void pushChildren(ASTNode node, boolean hasStub, StubElement stub) {
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (DefaultStubBuilder.this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                this.parentNodes.push(childNode);
                this.parentStubs.push(stub);
                this.parentNodesStubbed.push(hasStub);
            }
        }
    }
}

