/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0004J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\f\u0010\u001c\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "", "conditions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "firBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "isElse", "", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lcom/intellij/lang/LighterASTNode;Z)V", "getConditions", "()Ljava/util/List;", "getFirBlock", "()Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "()Z", "getNode", "()Lcom/intellij/lang/LighterASTNode;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toFirWhenCondition", "toFirWhenConditionWithoutSubject", "toString", "", "light-tree2fir"})
public final class WhenEntry {
    @NotNull
    private final List<FirExpression> conditions;
    @NotNull
    private final FirBlock firBlock;
    @NotNull
    private final LighterASTNode node;
    private final boolean isElse;

    public WhenEntry(@NotNull List<? extends FirExpression> conditions2, @NotNull FirBlock firBlock, @NotNull LighterASTNode node, boolean isElse) {
        Intrinsics.checkNotNullParameter(conditions2, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)firBlock, (String)"firBlock");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.conditions = conditions2;
        this.firBlock = firBlock;
        this.node = node;
        this.isElse = isElse;
    }

    public /* synthetic */ WhenEntry(List list2, FirBlock firBlock, LighterASTNode lighterASTNode2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list2, firBlock, lighterASTNode2, bl);
    }

    @NotNull
    public final List<FirExpression> getConditions() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock getFirBlock() {
        return this.firBlock;
    }

    @NotNull
    public final LighterASTNode getNode() {
        return this.node;
    }

    public final boolean isElse() {
        return this.isElse;
    }

    @NotNull
    public final FirExpression toFirWhenCondition() {
        FirExpression firCondition = null;
        for (FirExpression condition : this.conditions) {
            FirExpression firConditionElement = this.toFirWhenCondition(condition);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, firConditionElement, false, null);
        }
        FirExpression firExpression3 = firCondition;
        Intrinsics.checkNotNull(firExpression3);
        return firExpression3;
    }

    private final FirExpression toFirWhenCondition(FirExpression $this$toFirWhenCondition) {
        return $this$toFirWhenCondition;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirExpression toFirWhenConditionWithoutSubject() {
        void var1_1;
        FirExpression condition = (FirExpression)CollectionsKt.firstOrNull(this.conditions);
        return condition == null ? (FirExpression)FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax)) : var1_1;
    }

    @NotNull
    public final List<FirExpression> component1() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock component2() {
        return this.firBlock;
    }

    @NotNull
    public final LighterASTNode component3() {
        return this.node;
    }

    public final boolean component4() {
        return this.isElse;
    }

    @NotNull
    public final WhenEntry copy(@NotNull List<? extends FirExpression> conditions2, @NotNull FirBlock firBlock, @NotNull LighterASTNode node, boolean isElse) {
        Intrinsics.checkNotNullParameter(conditions2, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)firBlock, (String)"firBlock");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new WhenEntry(conditions2, firBlock, node, isElse);
    }

    public static /* synthetic */ WhenEntry copy$default(WhenEntry whenEntry, List list2, FirBlock firBlock, LighterASTNode lighterASTNode2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = whenEntry.conditions;
        }
        if ((n & 2) != 0) {
            firBlock = whenEntry.firBlock;
        }
        if ((n & 4) != 0) {
            lighterASTNode2 = whenEntry.node;
        }
        if ((n & 8) != 0) {
            bl = whenEntry.isElse;
        }
        return whenEntry.copy(list2, firBlock, lighterASTNode2, bl);
    }

    @NotNull
    public String toString() {
        return "WhenEntry(conditions=" + this.conditions + ", firBlock=" + this.firBlock + ", node=" + this.node + ", isElse=" + this.isElse + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.conditions).hashCode();
        result2 = result2 * 31 + this.firBlock.hashCode();
        result2 = result2 * 31 + this.node.hashCode();
        int n = this.isElse ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhenEntry)) {
            return false;
        }
        WhenEntry whenEntry = (WhenEntry)other;
        if (!Intrinsics.areEqual(this.conditions, whenEntry.conditions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firBlock, (Object)whenEntry.firBlock)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.node, (Object)whenEntry.node)) {
            return false;
        }
        return this.isElse == whenEntry.isElse;
    }
}

