/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\"\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00030!H\u0002J\u0016\u0010$\u001a\b\u0018\u00010\u0010R\u00020\u00032\u0006\u0010%\u001a\u00020\"H\u0002J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001e\u0010(\u001a\u00020\u001e2\n\u0010)\u001a\u00060\u0010R\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\"H\u0002J.\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\"2\b\u0010-\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0002J(\u00104\u001a\b\u0018\u00010\u0010R\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J(\u00109\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0010R\u00020\u00030!\u0018\u00010:2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020GH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0010R\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/js/dce/Analyzer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "(Lorg/jetbrains/kotlin/js/dce/Context;)V", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "astNodesToEliminate", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "astNodesToSkip", "functionsToEnter", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionsToSkip", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "invocationsToSkip", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleMapping", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "", "getModuleMapping", "()Ljava/util/Map;", "nodeMap", "postponedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "processedFunctions", "enterFunction", "", "function", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "enterFunctionWithGivenNodes", "extractVariableInitializedByEmptyObject", "expression", "handleAmdDefine", "invocation", "handleObjectCreate", "target", "arg", "handleObjectDefineProperty", "statement", "propertyName", "propertyDescriptor", "isProperFunctionalParameter", "", "body", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "processAssignment", "node", "lhs", "rhs", "processFunction", "tryExtractFunction", "Lkotlin/Pair;", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "js.dce"})
public final class Analyzer
extends JsVisitor {
    @NotNull
    private final Context context;
    @NotNull
    private final Set<JsFunction> processedFunctions;
    @NotNull
    private final Map<JsName, JsFunction> postponedFunctions;
    @NotNull
    private final Map<JsNode, Context.Node> nodeMap;
    @NotNull
    private final Set<JsNode> astNodesToEliminate;
    @NotNull
    private final Set<JsNode> astNodesToSkip;
    @NotNull
    private final Set<JsInvocation> invocationsToSkip;
    @NotNull
    private final Map<JsStatement, String> moduleMapping;
    @NotNull
    private final Set<JsFunction> functionsToEnter;
    @NotNull
    private final Set<Context.Node> functionsToSkip;
    @NotNull
    private final AnalysisResult analysisResult;

    public Analyzer(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.processedFunctions = new LinkedHashSet();
        bl = false;
        this.postponedFunctions = new LinkedHashMap();
        bl = false;
        this.nodeMap = new LinkedHashMap();
        bl = false;
        this.astNodesToEliminate = new LinkedHashSet();
        bl = false;
        this.astNodesToSkip = new LinkedHashSet();
        bl = false;
        this.invocationsToSkip = new LinkedHashSet();
        bl = false;
        this.moduleMapping = new LinkedHashMap();
        bl = false;
        this.functionsToEnter = new LinkedHashSet();
        bl = false;
        this.functionsToSkip = new LinkedHashSet();
        this.analysisResult = new AnalysisResult(this){
            final /* synthetic */ Analyzer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Map<JsNode, Context.Node> getNodeMap() {
                return Analyzer.access$getNodeMap$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToEliminate() {
                return Analyzer.access$getAstNodesToEliminate$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToSkip() {
                return Analyzer.access$getAstNodesToSkip$p(this.this$0);
            }

            @NotNull
            public Set<JsFunction> getFunctionsToEnter() {
                return Analyzer.access$getFunctionsToEnter$p(this.this$0);
            }

            @NotNull
            public Set<JsInvocation> getInvocationsToSkip() {
                return Analyzer.access$getInvocationsToSkip$p(this.this$0);
            }

            @NotNull
            public Set<Context.Node> getFunctionsToSkip() {
                return Analyzer.access$getFunctionsToSkip$p(this.this$0);
            }
        };
    }

    @NotNull
    public final Map<JsStatement, String> getModuleMapping() {
        return this.moduleMapping;
    }

    @NotNull
    public final AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        List<JsVars.JsVar> list2 = x.getVars();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"x.vars");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsExpression rhs = x.getInitExpression();
        if (rhs != null) {
            JsNode jsNode = x;
            Object object = x.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.name.makeRef()");
            Context.Node node = this.processAssignment(jsNode, (JsExpression)object, rhs);
            if (node != null) {
                object = node;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                Map<JsNode, Context.Node> map = this.nodeMap;
                boolean bl4 = false;
                map.put(x, (Context.Node)it);
            }
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        JsExpression expression2;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
        jsExpression = expression2 = jsExpression;
        if (jsExpression instanceof JsBinaryOperation) {
            if (((JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.ASG) {
                JsNode jsNode = x;
                Object object = ((JsBinaryOperation)expression2).getArg1();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expression.arg1");
                JsExpression jsExpression2 = object;
                object = ((JsBinaryOperation)expression2).getArg2();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expression.arg2");
                Context.Node node = this.processAssignment(jsNode, jsExpression2, (JsExpression)object);
                if (node != null) {
                    object = node;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    Map<JsNode, Context.Node> map = this.nodeMap;
                    boolean bl4 = false;
                    map.put(x, (Context.Node)it);
                }
            }
        } else if (jsExpression instanceof JsFunction) {
            JsName jsName = ((JsFunction)expression2).getName();
            if (jsName != null) {
                Object object = jsName;
                boolean bl = false;
                boolean bl5 = false;
                Object it = object;
                boolean bl6 = false;
                Object object2 = this.context.getNodes().get(it);
                Context.Node node = object2 == null ? null : ((Context.Node)object2).getOriginal();
                if (node != null) {
                    object = node;
                    bl = false;
                    bl5 = false;
                    it = object;
                    boolean bl7 = false;
                    object2 = this.nodeMap;
                    boolean bl8 = false;
                    object2.put(x, it);
                    ((Context.Node)it).addFunction((JsFunction)expression2);
                }
            }
        } else if (jsExpression instanceof JsInvocation) {
            Object object;
            List<JsExpression> list2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.qualifier");
            JsExpression function2 = list2;
            if (function2 instanceof JsFunction) {
                JsFunction jsFunction = (JsFunction)function2;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.arguments");
                this.enterFunction(jsFunction, (List<? extends JsExpression>)list2);
                return;
            }
            if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null) {
                boolean bl;
                Object object3;
                JsFunction jsFunction;
                object = ((JsNameRef)function2).getName();
                if (object == null) {
                    jsFunction = null;
                } else {
                    object3 = object;
                    boolean bl9 = false;
                    bl = false;
                    JsName it = object3;
                    boolean bl10 = false;
                    jsFunction = this.postponedFunctions.get(it);
                }
                JsFunction postponedFunction = jsFunction;
                if (postponedFunction != null) {
                    object = ((JsInvocation)expression2).getArguments();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"expression.arguments");
                    this.enterFunction(postponedFunction, (List<? extends JsExpression>)object);
                    object = this;
                    object3 = ((Analyzer)object).invocationsToSkip;
                    JsExpression jsExpression3 = expression2;
                    bl = false;
                    object3.add(jsExpression3);
                    return;
                }
            }
            if (UtilKt.isObjectDefineProperty(this.context, function2)) {
                JsStatement jsStatement = x;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.arguments");
                JsExpression jsExpression4 = (JsExpression)CollectionsKt.getOrNull((List)list2, (int)0);
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.arguments");
                JsExpression jsExpression5 = (JsExpression)CollectionsKt.getOrNull(list2, (int)1);
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.arguments");
                this.handleObjectDefineProperty(jsStatement, jsExpression4, jsExpression5, (JsExpression)CollectionsKt.getOrNull(list2, (int)2));
            } else if (UtilKt.isDefineModule(this.context, function2)) {
                list2 = this;
                object = ((Analyzer)((Object)list2)).astNodesToEliminate;
                boolean bl = false;
                object.add((JsExpression)((Object)x));
            } else if (UtilKt.isAmdDefine(this.context, function2)) {
                JsInvocation jsInvocation = (JsInvocation)expression2;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.arguments");
                this.handleAmdDefine(jsInvocation, list2);
            }
        }
    }

    private final void handleObjectDefineProperty(JsStatement statement2, JsExpression target, JsExpression propertyName, JsExpression propertyDescriptor) {
        if (target == null || !(propertyName instanceof JsStringLiteral) || propertyDescriptor == null) {
            return;
        }
        Context.Node node = this.context.extractNode(target);
        if (node == null) {
            return;
        }
        Context.Node targetNode = node;
        Iterator<JsPropertyInitializer> iterator2 = ((JsStringLiteral)propertyName).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"propertyName.value");
        Context.Node memberNode = targetNode.member((String)((Object)iterator2));
        iterator2 = this.nodeMap;
        boolean bl = false;
        iterator2.put(statement2, memberNode);
        memberNode.setHasSideEffects(true);
        if (propertyDescriptor instanceof JsObjectLiteral) {
            for (JsPropertyInitializer initializer2 : ((JsObjectLiteral)propertyDescriptor).getPropertyInitializers()) {
                JsNode jsNode = statement2;
                JsExpression jsExpression = new JsNameRef(((JsStringLiteral)propertyName).getValue(), target);
                JsExpression jsExpression2 = initializer2.getValueExpr();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"initializer.valueExpr");
                this.processAssignment(jsNode, jsExpression, jsExpression2);
            }
        } else if (propertyDescriptor instanceof JsInvocation) {
            JsExpression initializer2 = ((JsInvocation)propertyDescriptor).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)initializer2, (String)"propertyDescriptor.qualifier");
            JsExpression function2 = initializer2;
            if (UtilKt.isObjectGetOwnPropertyDescriptor(this.context, function2)) {
                List<JsExpression> list2 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyDescriptor.arguments");
                JsExpression source = (JsExpression)CollectionsKt.getOrNull(list2, (int)0);
                List<JsExpression> list3 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"propertyDescriptor.arguments");
                JsExpression sourcePropertyName = (JsExpression)CollectionsKt.getOrNull(list3, (int)1);
                if (source != null && sourcePropertyName instanceof JsStringLiteral) {
                    this.processAssignment(statement2, new JsNameRef(((JsStringLiteral)propertyName).getValue(), target), new JsNameRef(((JsStringLiteral)sourcePropertyName).getValue(), source));
                }
            }
        }
    }

    private final void handleAmdDefine(JsInvocation invocation, List<? extends JsExpression> arguments2) {
        Object object;
        JsStringLiteral it;
        Object object2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object3;
        HasMetadata hasMetadata;
        Object object4;
        JsArrayLiteral jsArrayLiteral;
        List list2;
        int n = arguments2.size();
        switch (n) {
            case 2: {
                list2 = arguments2;
                break;
            }
            case 3: {
                list2 = CollectionsKt.drop((Iterable)arguments2, (int)1);
                break;
            }
            default: {
                return;
            }
        }
        List argumentsWithoutName = list2;
        Object e = argumentsWithoutName.get(0);
        JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral = e instanceof JsArrayLiteral ? (JsArrayLiteral)e : null;
        if (jsArrayLiteral == null) {
            return;
        }
        JsArrayLiteral dependencies2 = jsArrayLiteral;
        JsExpression functionRef = (JsExpression)argumentsWithoutName.get(1);
        JsExpression jsExpression = functionRef;
        if (jsExpression instanceof JsFunction) {
            object4 = (JsFunction)functionRef;
        } else if (jsExpression instanceof JsNameRef) {
            if (((JsNameRef)functionRef).getQualifier() != null) {
                return;
            }
            Map<JsName, JsFunction> map = this.postponedFunctions;
            hasMetadata = ((JsNameRef)functionRef).getName();
            boolean bl = false;
            object3 = map.get(hasMetadata);
            if (object3 == null) {
                return;
            }
            object4 = object3;
        } else {
            return;
        }
        JsFunction function2 = object4;
        object3 = dependencies2.getExpressions();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"dependencies.expressions");
        object3 = (Iterable)object3;
        boolean $i$f$map = false;
        hasMetadata = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsExpression jsExpression2 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object5 = object2 = it instanceof JsStringLiteral ? (JsStringLiteral)it : null;
            if (object2 == null) {
                return;
            }
            object = object2;
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Context.Node node;
            it = (JsStringLiteral)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getValue(), (Object)"exports")) {
                node = this.context.getCurrentModule();
            } else {
                Context.Node node2 = this.context.getGlobalScope();
                object2 = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.value");
                node = node2.member((String)object2);
            }
            object = node;
            collection.add(object);
        }
        List dependencyNodes = (List)destination$iv$iv;
        this.enterFunctionWithGivenNodes(function2, dependencyNodes);
        object3 = this;
        Collection collection2 = ((Analyzer)object3).astNodesToSkip;
        hasMetadata = invocation.getQualifier();
        boolean bl = false;
        collection2.add(hasMetadata);
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        String newModule = this.moduleMapping.get(x);
        if (newModule != null) {
            this.context.setCurrentModule(this.context.getGlobalScope().member(newModule));
        }
        List<JsStatement> list2 = x.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"x.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        this.accept((JsNode)x.getThenStatement());
        JsStatement jsStatement = x.getElseStatement();
        if (jsStatement != null) {
            jsStatement.accept(this);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Context.Node node;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsExpression expr = x.getExpression();
        if (expr != null && (node = this.context.extractNode(expr)) != null) {
            Context.Node node2 = node;
            boolean bl = false;
            boolean bl2 = false;
            Context.Node it = node2;
            boolean bl3 = false;
            Map<JsNode, Context.Node> map = this.nodeMap;
            boolean bl4 = false;
            map.put(x, it);
        }
    }

    private final Context.Node processAssignment(JsNode node, JsExpression lhs, JsExpression rhs) {
        Context.Node leftNode = this.context.extractNode(lhs);
        Context.Node rightNode = this.context.extractNode(rhs);
        if (leftNode != null && rightNode != null) {
            leftNode.alias(rightNode);
            return leftNode;
        }
        if (leftNode != null) {
            Object object;
            List<JsExpression> list2;
            if (rhs instanceof JsInvocation) {
                boolean bl;
                list2 = ((JsInvocation)rhs).getQualifier();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"rhs.qualifier");
                JsExpression function2 = list2;
                if (function2 instanceof JsFunction) {
                    JsFunction jsFunction = (JsFunction)function2;
                    list2 = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"rhs.arguments");
                    this.enterFunction(jsFunction, list2);
                    list2 = this;
                    Collection collection = ((Analyzer)((Object)list2)).astNodesToSkip;
                    boolean bl2 = false;
                    collection.add(lhs);
                    return null;
                }
                if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null && (list2 = ((JsNameRef)function2).getName()) != null) {
                    Object object2 = list2;
                    bl = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    object = this.postponedFunctions.get(it);
                    if (object != null) {
                        object2 = object;
                        bl = false;
                        bl3 = false;
                        it = object2;
                        boolean bl5 = false;
                        Object object3 = ((JsInvocation)rhs).getArguments();
                        Intrinsics.checkNotNullExpressionValue(object3, (String)"rhs.arguments");
                        this.enterFunction((JsFunction)it, (List<? extends JsExpression>)object3);
                        object3 = this;
                        Collection collection = ((Analyzer)object3).astNodesToSkip;
                        boolean bl6 = false;
                        collection.add(lhs);
                        return null;
                    }
                }
                if (UtilKt.isObjectFunction(this.context, function2, "create")) {
                    list2 = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"rhs.arguments");
                    this.handleObjectCreate(leftNode, (JsExpression)CollectionsKt.getOrNull(list2, (int)0));
                    return leftNode;
                }
                if (UtilKt.isDefineInlineFunction(this.context, function2) && ((JsInvocation)rhs).getArguments().size() == 2) {
                    object = ((JsInvocation)rhs).getArguments().get(1);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rhs.arguments[1]");
                    list2 = this.tryExtractFunction((JsExpression)object);
                    if (list2 != null) {
                        object = list2;
                        boolean bl7 = false;
                        bl = false;
                        List<JsExpression> $dstr$inlineableFunction$additionalDeps = object;
                        boolean bl8 = false;
                        JsFunction inlineableFunction = (JsFunction)$dstr$inlineableFunction$additionalDeps.component1();
                        List additionalDeps = (List)$dstr$inlineableFunction$additionalDeps.component2();
                        leftNode.addFunction(inlineableFunction);
                        Context.Node defineInlineFunctionNode = this.context.extractNode(function2);
                        if (defineInlineFunctionNode != null) {
                            leftNode.addDependency(defineInlineFunctionNode);
                        }
                        Iterable $this$forEach$iv = additionalDeps;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Context.Node it = (Context.Node)element$iv;
                            boolean bl9 = false;
                            leftNode.addDependency(it);
                        }
                        return leftNode;
                    }
                }
                if ((list2 = this.tryExtractFunction(rhs)) != null) {
                    object = list2;
                    boolean bl10 = false;
                    bl = false;
                    List<JsExpression> $dstr$functionBody$additionalDeps = object;
                    boolean bl11 = false;
                    JsFunction functionBody = (JsFunction)$dstr$functionBody$additionalDeps.component1();
                    List additionalDeps = (List)$dstr$functionBody$additionalDeps.component2();
                    leftNode.addFunction(functionBody);
                    Iterable $this$forEach$iv = additionalDeps;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Context.Node it = (Context.Node)element$iv;
                        boolean bl12 = false;
                        leftNode.addDependency(it);
                    }
                    return leftNode;
                }
            } else if (rhs instanceof JsBinaryOperation) {
                if (((JsBinaryOperation)rhs).getOperator() == JsBinaryOperator.OR) {
                    list2 = ((JsBinaryOperation)rhs).getArg1();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"rhs.arg1");
                    Context.Node secondNode = this.context.extractNode((JsExpression)((Object)list2));
                    JsExpression reassignment = ((JsBinaryOperation)rhs).getArg2();
                    if (reassignment instanceof JsBinaryOperation && ((JsBinaryOperation)reassignment).getOperator() == JsBinaryOperator.ASG) {
                        JsExpression jsExpression = ((JsBinaryOperation)reassignment).getArg1();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"reassignment.arg1");
                        Context.Node reassignNode = this.context.extractNode(jsExpression);
                        JsExpression reassignValue = ((JsBinaryOperation)reassignment).getArg2();
                        if (Intrinsics.areEqual((Object)reassignNode, (Object)secondNode) && reassignNode != null && reassignValue instanceof JsObjectLiteral && ((JsObjectLiteral)reassignValue).getPropertyInitializers().isEmpty()) {
                            JsExpression jsExpression2 = ((JsBinaryOperation)rhs).getArg1();
                            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"rhs.arg1");
                            return this.processAssignment(node, lhs, jsExpression2);
                        }
                    }
                }
            } else {
                if (rhs instanceof JsFunction) {
                    leftNode.addFunction((JsFunction)rhs);
                    return leftNode;
                }
                if (Intrinsics.areEqual((Object)leftNode.getMemberName(), (Object)"$metadata$")) {
                    leftNode.addExpression(rhs);
                    return leftNode;
                }
                if (rhs instanceof JsObjectLiteral && ((JsObjectLiteral)rhs).getPropertyInitializers().isEmpty()) {
                    return leftNode;
                }
            }
            Context.Node nodeInitializedByEmptyObject = this.extractVariableInitializedByEmptyObject(rhs);
            if (nodeInitializedByEmptyObject != null) {
                list2 = this;
                object = (List<JsExpression>)((Object)((Analyzer)((Object)list2)).astNodesToSkip);
                boolean bl = false;
                object.add(rhs);
                leftNode.alias(nodeInitializedByEmptyObject);
                return leftNode;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsFunction, List<Context.Node>> tryExtractFunction(JsExpression expression2) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            return new Pair((Object)expression2, (Object)CollectionsKt.emptyList());
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"expression.qualifier");
            if (UtilKt.isWrapFunction(this.context, jsExpression2)) {
                List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.arguments");
                Object object = CollectionsKt.getOrNull(list2, (int)0);
                JsExpression jsExpression3 = jsExpression2 = object instanceof JsFunction ? (JsFunction)object : null;
                if (jsExpression2 != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Object it;
                    Object object2;
                    Object it2;
                    void $this$filterTo$iv$iv;
                    object = jsExpression2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object wrapper = object;
                    boolean bl3 = false;
                    List<JsStatement> list3 = ((JsFunction)wrapper).getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"wrapper.body.statements");
                    Object $this$filter$iv = list3;
                    boolean $i$f$filter22 = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (JsStatement)element$iv$iv;
                        boolean bl4 = false;
                        if (!(!(it2 instanceof JsReturn))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List statementsWithoutBody = (List)destination$iv$iv;
                    $this$filter$iv = new JsBlock(statementsWithoutBody);
                    $i$f$filter22 = false;
                    boolean bl5 = false;
                    Object it32 = $this$filter$iv;
                    boolean bl6 = false;
                    this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectDefinedNames((JsNode)it32));
                    this.accept((JsNode)it32);
                    Object object3 = ((JsInvocation)expression2).getQualifier();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"expression.qualifier");
                    Context.Node $i$f$filter22 = this.context.extractNode((JsExpression)object3);
                    if ($i$f$filter22 == null) {
                        object2 = null;
                    } else {
                        object3 = $i$f$filter22;
                        boolean it32 = false;
                        bl6 = false;
                        it = object3;
                        boolean bl7 = false;
                        it2 = this;
                        Collection collection = ((Analyzer)it2).functionsToSkip;
                        boolean bl8 = false;
                        collection.add(it);
                        object2 = object3;
                    }
                    Object wrapperNode = object2;
                    List<JsStatement> it32 = ((JsFunction)wrapper).getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(it32, (String)"wrapper.body.statements");
                    Iterable $this$filterIsInstance$iv = it32;
                    boolean $i$f$filterIsInstance = false;
                    it = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsReturn)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    object3 = ((JsReturn)CollectionsKt.first((List)((List)destination$iv$iv2))).getExpression();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsFunction");
                    }
                    JsFunction body2 = (JsFunction)object3;
                    return new Pair((Object)body2, (Object)CollectionsKt.listOfNotNull((Object)wrapperNode));
                }
            }
        }
        return null;
    }

    private final void handleObjectCreate(Context.Node target, JsExpression arg) {
        if (arg == null) {
            return;
        }
        Context.Node node = this.context.extractNode(arg);
        if (node == null) {
            return;
        }
        Context.Node prototypeNode = node;
        target.addDependency(prototypeNode.getOriginal());
        target.addExpression(arg);
    }

    private final Context.Node extractVariableInitializedByEmptyObject(JsExpression expression2) {
        JsBinaryOperation jsBinaryOperation;
        if (!(expression2 instanceof JsConditional)) {
            return null;
        }
        JsExpression jsExpression = ((JsConditional)expression2).getTestExpression();
        JsBinaryOperation jsBinaryOperation2 = jsBinaryOperation = jsExpression instanceof JsBinaryOperation ? (JsBinaryOperation)jsExpression : null;
        if (jsBinaryOperation == null) {
            return null;
        }
        JsBinaryOperation testExpr = jsBinaryOperation;
        if (testExpr.getOperator() != JsBinaryOperator.REF_EQ) {
            return null;
        }
        Object object = testExpr.getArg1();
        JsExpression jsExpression2 = jsExpression = object instanceof JsPrefixOperation ? (JsPrefixOperation)object : null;
        if (jsExpression == null) {
            return null;
        }
        JsExpression testExprLhs = jsExpression;
        if (((JsUnaryOperation)testExprLhs).getOperator() != JsUnaryOperator.TYPEOF) {
            return null;
        }
        JsExpression jsExpression3 = ((JsUnaryOperation)testExprLhs).getArg();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"testExprLhs.arg");
        object = this.context.extractNode(jsExpression3);
        if (object == null) {
            return null;
        }
        Object testExprNode = object;
        Object object2 = testExpr.getArg2();
        JsExpression jsExpression4 = jsExpression3 = object2 instanceof JsStringLiteral ? (JsStringLiteral)object2 : null;
        if (jsExpression3 == null) {
            return null;
        }
        JsExpression testExprRhs = jsExpression3;
        if (!Intrinsics.areEqual((Object)((JsStringLiteral)testExprRhs).getValue(), (Object)"undefined")) {
            return null;
        }
        JsExpression jsExpression5 = ((JsConditional)expression2).getThenExpression();
        Object object3 = object2 = jsExpression5 instanceof JsObjectLiteral ? (JsObjectLiteral)jsExpression5 : null;
        if (object2 == null) {
            return null;
        }
        JsExpression thenExpr = object2;
        object2 = ((JsObjectLiteral)thenExpr).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"thenExpr.propertyInitializers");
        object2 = (Collection)object2;
        boolean bl = false;
        if (!object2.isEmpty()) {
            return null;
        }
        JsExpression jsExpression6 = ((JsConditional)expression2).getElseExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression6, (String)"expression.elseExpression");
        Context.Node node = this.context.extractNode(jsExpression6);
        if (node == null) {
            return null;
        }
        Context.Node elseNode = node;
        if (!Intrinsics.areEqual((Object)((Context.Node)testExprNode).getOriginal(), (Object)elseNode.getOriginal())) {
            return null;
        }
        return ((Context.Node)testExprNode).getOriginal();
    }

    private final void enterFunction(JsFunction function2, List<? extends JsExpression> arguments2) {
        Iterator iterator2 = this;
        Pair pair2 = (Pair)((Analyzer)((Object)iterator2)).functionsToEnter;
        boolean bl = false;
        pair2.add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        iterator2 = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"function.body");
        this.context.markSpecialFunctions((JsNode)((Object)iterator2));
        pair2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(pair2, (String)"function.parameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)((Iterable)pair2), (Iterable)arguments2)) {
            Object object;
            Map<JsName, JsFunction> map;
            JsParameter param = (JsParameter)pair2.component1();
            JsExpression arg = (JsExpression)pair2.component2();
            if (arg instanceof JsFunction && ((JsFunction)arg).getName() == null) {
                map = ((JsFunction)arg).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"arg.body");
                JsStatement jsStatement = (JsStatement)((Object)map);
                Intrinsics.checkNotNullExpressionValue((Object)param, (String)"param");
                if (this.isProperFunctionalParameter(jsStatement, param)) {
                    map = this.postponedFunctions;
                    object = param.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"param.name");
                    JsExpression jsExpression = arg;
                    boolean bl2 = false;
                    map.put((JsName)object, (JsFunction)jsExpression);
                    continue;
                }
            }
            JsNode jsNode = function2;
            map = param.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"param.name.makeRef()");
            if (this.processAssignment(jsNode, (JsExpression)((Object)map), arg) == null) continue;
            map = this;
            object = ((Analyzer)((Object)map)).astNodesToSkip;
            boolean bl3 = false;
            object.add(arg);
        }
        this.processFunction(function2);
    }

    private final void enterFunctionWithGivenNodes(JsFunction function2, List<Context.Node> arguments2) {
        Iterator iterator2 = this;
        Pair pair2 = (Pair)((Analyzer)((Object)iterator2)).functionsToEnter;
        boolean bl = false;
        pair2.add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        iterator2 = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"function.body");
        this.context.markSpecialFunctions((JsNode)((Object)iterator2));
        pair2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(pair2, (String)"function.parameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)((Iterable)pair2), (Iterable)arguments2)) {
            Context.Node paramNode;
            JsParameter param = (JsParameter)pair2.component1();
            Context.Node arg = (Context.Node)pair2.component2();
            Intrinsics.checkNotNull((Object)this.context.getNodes().get(param.getName()));
            paramNode.alias(arg);
        }
        this.processFunction(function2);
    }

    private final void processFunction(JsFunction function2) {
        if (this.processedFunctions.add(function2)) {
            this.accept((JsNode)function2.getBody());
        }
    }

    private final boolean isProperFunctionalParameter(JsStatement body2, JsParameter parameter) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        body2.accept(new RecursiveJsVisitor(parameter, this, result2){
            final /* synthetic */ JsParameter $parameter;
            final /* synthetic */ Analyzer this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$parameter = $parameter;
                this.this$0 = $receiver;
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                Object object = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.qualifier");
                JsExpression qualifier = object;
                if (qualifier instanceof JsNameRef && ((JsNameRef)qualifier).getQualifier() == null && Intrinsics.areEqual((Object)((JsNameRef)qualifier).getName(), (Object)this.$parameter.getName())) {
                    boolean bl;
                    block6: {
                        void $this$all$iv;
                        object = invocation.getArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.arguments");
                        object = (Iterable)object;
                        Analyzer analyzer2 = this.this$0;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                JsExpression it = (JsExpression)element$iv;
                                boolean bl2 = false;
                                Context context2 = Analyzer.access$getContext$p(analyzer2);
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                if (context2.extractNode(it) != null) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (UtilKt.isAmdDefine(Analyzer.access$getContext$p(this.this$0), qualifier)) {
                    return;
                }
                super.visitInvocation(invocation);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                if (Intrinsics.areEqual((Object)nameRef.getName(), (Object)this.$parameter.getName())) {
                    this.$result.element = false;
                }
                super.visitNameRef(nameRef);
            }
        });
        return result2.element;
    }

    public static final /* synthetic */ Context access$getContext$p(Analyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ Map access$getNodeMap$p(Analyzer $this) {
        return $this.nodeMap;
    }

    public static final /* synthetic */ Set access$getAstNodesToEliminate$p(Analyzer $this) {
        return $this.astNodesToEliminate;
    }

    public static final /* synthetic */ Set access$getAstNodesToSkip$p(Analyzer $this) {
        return $this.astNodesToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToEnter$p(Analyzer $this) {
        return $this.functionsToEnter;
    }

    public static final /* synthetic */ Set access$getInvocationsToSkip$p(Analyzer $this) {
        return $this.invocationsToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToSkip$p(Analyzer $this) {
        return $this.functionsToSkip;
    }
}

