/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.File;
import java.util.Set;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;

public class IvyNormalizedPublication {
    private final String name;
    private final IvyPublicationIdentity projectIdentity;
    private final File ivyDescriptorFile;
    private final Set<IvyArtifact> allArtifacts;
    private final IvyArtifactSet mainArtifacts;

    public IvyNormalizedPublication(String name, IvyArtifactSet mainArtifacts, IvyPublicationIdentity projectIdentity, File ivyDescriptorFile, Set<IvyArtifact> allArtifacts) {
        this.name = name;
        this.projectIdentity = projectIdentity;
        this.ivyDescriptorFile = ivyDescriptorFile;
        this.allArtifacts = allArtifacts;
        this.mainArtifacts = mainArtifacts;
    }

    public String getName() {
        return this.name;
    }

    public IvyPublicationIdentity getProjectIdentity() {
        return this.projectIdentity;
    }

    public File getIvyDescriptorFile() {
        return this.ivyDescriptorFile;
    }

    public Set<IvyArtifact> getAllArtifacts() {
        this.assertMainArtifactsPublishable();
        return this.allArtifacts;
    }

    private void assertMainArtifactsPublishable() {
        this.mainArtifacts.all(artifact -> {
            if (artifact.getClassifier() == null && !((PublicationArtifactInternal)artifact).shouldBePublished()) {
                throw new IllegalStateException("Artifact " + artifact.getFile().getName() + " wasn't produced by this build.");
            }
        });
    }
}

