/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.deprecation.ConfigurationDeprecationType;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessage;
import org.gradle.internal.deprecation.DeprecationTimeline;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.util.GradleVersion;

@CheckReturnValue
public class DeprecationMessageBuilder<T extends DeprecationMessageBuilder<T>> {
    private static final GradleVersion GRADLE8 = GradleVersion.version((String)"8.0");
    private String summary;
    private DeprecationTimeline deprecationTimeline;
    private String context;
    private String advice;
    private Documentation documentation = Documentation.NO_DOCUMENTATION;
    private DeprecatedFeatureUsage.Type usageType = DeprecatedFeatureUsage.Type.USER_CODE_DIRECT;

    DeprecationMessageBuilder() {
    }

    public T withContext(String context) {
        this.context = context;
        return (T)this;
    }

    public T withAdvice(String advice) {
        this.advice = advice;
        return (T)this;
    }

    public WithDeprecationTimeline willBeRemovedInGradle8() {
        this.deprecationTimeline = DeprecationTimeline.willBeRemovedInVersion(GRADLE8);
        return new WithDeprecationTimeline(this);
    }

    public WithDeprecationTimeline willBecomeAnErrorInGradle8() {
        this.deprecationTimeline = DeprecationTimeline.willBecomeAnErrorInVersion(GRADLE8);
        return new WithDeprecationTimeline(this);
    }

    void setIndirectUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT;
    }

    void setBuildInvocationUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.BUILD_INVOCATION;
    }

    void setSummary(String summary) {
        this.summary = summary;
    }

    void setAdvice(String advice) {
        this.advice = advice;
    }

    void setDeprecationTimeline(DeprecationTimeline deprecationTimeline) {
        this.deprecationTimeline = deprecationTimeline;
    }

    void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    DeprecationMessage build() {
        return new DeprecationMessage(this.summary, this.deprecationTimeline.toString(), this.advice, this.context, this.documentation, this.usageType);
    }

    public static class DeprecateBehaviour
    extends DeprecationMessageBuilder<DeprecateBehaviour> {
        private final String behaviour;

        public DeprecateBehaviour(String behaviour) {
            this.behaviour = behaviour;
        }

        @Override
        public WithDeprecationTimeline willBeRemovedInGradle8() {
            this.setDeprecationTimeline(DeprecationTimeline.behaviourWillBeRemovedInVersion(GRADLE8));
            return new WithDeprecationTimeline(this);
        }

        @Override
        DeprecationMessage build() {
            this.setSummary(this.behaviour);
            return super.build();
        }
    }

    public static class DeprecateInternalApi
    extends WithReplacement<String, DeprecateInternalApi> {
        DeprecateInternalApi(String api) {
            super(api);
        }

        @Override
        String formatSummary(String api) {
            return String.format("Internal API %s has been deprecated.", api);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use %s instead.", replacement);
        }
    }

    public static class DeprecatePlugin
    extends WithReplacement<String, DeprecatePlugin> {
        private boolean externalReplacement = false;

        DeprecatePlugin(String plugin) {
            super(plugin);
        }

        @Override
        String formatSummary(String plugin) {
            return String.format("The %s plugin has been deprecated.", plugin);
        }

        @Override
        String formatAdvice(String replacement) {
            return this.externalReplacement ? String.format("Consider using the %s plugin instead.", replacement) : String.format("Please use the %s plugin instead.", replacement);
        }

        public DeprecatePlugin replaceWithExternalPlugin(String replacement) {
            this.externalReplacement = true;
            return (DeprecatePlugin)this.replaceWith(replacement);
        }
    }

    public static class DeprecateTaskType
    extends WithReplacement<Class<?>, DeprecateTaskType> {
        private final String path;

        DeprecateTaskType(String task, String path) {
            super(task);
            this.path = path;
        }

        @Override
        String formatSummary(String type) {
            return String.format("The task type %s (used by the %s task) has been deprecated.", type, this.path);
        }

        @Override
        String formatAdvice(Class<?> replacement) {
            return String.format("Please use the %s type instead.", replacement.getCanonicalName());
        }
    }

    public static class DeprecateTask
    extends WithReplacement<String, DeprecateTask> {
        DeprecateTask(String task) {
            super(task);
        }

        @Override
        String formatSummary(String task) {
            return String.format("The %s task has been deprecated.", task);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s task instead.", replacement);
        }
    }

    public static class DeprecateInvocation
    extends WithReplacement<String, DeprecateInvocation> {
        DeprecateInvocation(String invocation) {
            super(invocation);
        }

        @Override
        String formatSummary(String invocation) {
            return String.format("Using method %s has been deprecated.", invocation);
        }

        @Override
        String formatAdvice(String replacement) {
            return DeprecateMethod.pleaseUseThisMethodInstead(replacement);
        }
    }

    public static class DeprecateMethod
    extends WithReplacement<String, DeprecateMethod> {
        private final Class<?> methodClass;
        private final String methodWithParams;

        DeprecateMethod(Class<?> methodClass, String methodWithParams) {
            super(methodWithParams);
            this.methodClass = methodClass;
            this.methodWithParams = methodWithParams;
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.methodClass.getSimpleName(), this.methodWithParams);
        }

        @Override
        String formatSummary(String method) {
            return String.format("The %s method has been deprecated.", method);
        }

        @Override
        String formatAdvice(String replacement) {
            return DeprecateMethod.pleaseUseThisMethodInstead(replacement);
        }

        private static String pleaseUseThisMethodInstead(String replacement) {
            return String.format("Please use the %s method instead.", replacement);
        }
    }

    public static class DeprecateConfiguration
    extends WithReplacement<List<String>, DeprecateConfiguration> {
        private final ConfigurationDeprecationType deprecationType;

        DeprecateConfiguration(String configuration, ConfigurationDeprecationType deprecationType) {
            super(configuration);
            this.deprecationType = deprecationType;
            if (!deprecationType.inUserCode) {
                this.setIndirectUsage();
            }
        }

        @Override
        String formatSummary(String configuration) {
            return String.format("The %s configuration has been deprecated for %s.", configuration, this.deprecationType.displayName());
        }

        @Override
        String formatAdvice(List<String> replacements) {
            return String.format("Please %s the %s configuration instead.", this.deprecationType.usage, Joiner.on((String)" or ").join(replacements));
        }
    }

    @CheckReturnValue
    public static class ConfigurationDeprecationTypeSelector {
        private final String configuration;

        ConfigurationDeprecationTypeSelector(String configuration) {
            this.configuration = configuration;
        }

        public DeprecateConfiguration forArtifactDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.ARTIFACT_DECLARATION);
        }

        public DeprecateConfiguration forConsumption() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.CONSUMPTION);
        }

        public DeprecateConfiguration forDependencyDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.DEPENDENCY_DECLARATION);
        }

        public DeprecateConfiguration forResolution() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.RESOLUTION);
        }
    }

    public static class DeprecateSystemProperty
    extends WithReplacement<String, DeprecateSystemProperty> {
        private final String systemProperty;

        DeprecateSystemProperty(String systemProperty) {
            super(systemProperty);
            this.systemProperty = systemProperty;
            this.setIndirectUsage();
        }

        @Override
        String formatSubject() {
            return this.systemProperty;
        }

        @Override
        String formatSummary(String property) {
            return String.format("The %s system property has been deprecated.", property);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s system property instead.", replacement);
        }
    }

    public static class DeprecateProperty
    extends WithReplacement<String, DeprecateProperty> {
        private final Class<?> propertyClass;
        private final String property;

        DeprecateProperty(Class<?> propertyClass, String property) {
            super(property);
            this.propertyClass = propertyClass;
            this.property = property;
        }

        @Override
        public WithDeprecationTimeline willBeRemovedInGradle8() {
            this.setDeprecationTimeline(DeprecationTimeline.willBeRemovedInVersion(GRADLE8));
            return new WithDeprecationTimeline(this);
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.propertyClass.getSimpleName(), this.property);
        }

        @Override
        String formatSummary(String property) {
            return String.format("The %s property has been deprecated.", property);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s property instead.", replacement);
        }

        public class WithDeprecationTimeline
        extends org.gradle.internal.deprecation.DeprecationMessageBuilder$WithDeprecationTimeline {
            private final DeprecateProperty builder;

            public WithDeprecationTimeline(DeprecateProperty builder) {
                super(builder);
                this.builder = builder;
            }

            public WithDocumentation withDslReference() {
                DeprecateProperty.this.setDocumentation(Documentation.dslReference(DeprecateProperty.this.propertyClass, DeprecateProperty.this.property));
                return new WithDocumentation(this.builder);
            }
        }
    }

    public static class DeprecateNamedParameter
    extends WithReplacement<String, DeprecateNamedParameter> {
        DeprecateNamedParameter(String parameter) {
            super(parameter);
        }

        @Override
        String formatSummary(String parameter) {
            return String.format("The %s named parameter has been deprecated.", parameter);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s named parameter instead.", replacement);
        }
    }

    public static abstract class WithReplacement<T, SELF extends WithReplacement<T, SELF>>
    extends DeprecationMessageBuilder<SELF> {
        private final String subject;
        private T replacement;

        WithReplacement(String subject) {
            this.subject = subject;
        }

        public SELF replaceWith(T replacement) {
            this.replacement = replacement;
            return (SELF)this;
        }

        String formatSubject() {
            return this.subject;
        }

        abstract String formatSummary(String var1);

        abstract String formatAdvice(T var1);

        @Override
        DeprecationMessage build() {
            this.setSummary(this.formatSummary(this.formatSubject()));
            if (this.replacement != null) {
                this.setAdvice(this.formatAdvice(this.replacement));
            }
            return super.build();
        }
    }

    public static class WithDocumentation {
        private final DeprecationMessageBuilder<?> builder;

        WithDocumentation(DeprecationMessageBuilder<?> builder) {
            this.builder = builder;
        }

        public void nagUser() {
            DeprecationLogger.nagUserWith(this.builder, WithDocumentation.class);
        }
    }

    public static class WithDeprecationTimeline {
        private final DeprecationMessageBuilder<?> builder;

        public WithDeprecationTimeline(DeprecationMessageBuilder<?> builder) {
            this.builder = builder;
        }

        public WithDocumentation undocumented() {
            return new WithDocumentation(this.builder);
        }

        public WithDocumentation withUserManual(String documentationId) {
            this.builder.setDocumentation(Documentation.userManual(documentationId));
            return new WithDocumentation(this.builder);
        }

        public WithDocumentation withUserManual(String documentationId, String section) {
            this.builder.setDocumentation(Documentation.userManual(documentationId, section));
            return new WithDocumentation(this.builder);
        }

        public WithDocumentation withDslReference(Class<?> targetClass, String property) {
            this.builder.setDocumentation(Documentation.dslReference(targetClass, property));
            return new WithDocumentation(this.builder);
        }

        public WithDocumentation withUpgradeGuideSection(int majorVersion, String upgradeGuideSection) {
            this.builder.setDocumentation(Documentation.upgradeGuide(majorVersion, upgradeGuideSection));
            return new WithDocumentation(this.builder);
        }
    }
}

