/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.EnumSet;
import java.util.Set;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestStackTraceFilter;
import org.gradle.util.internal.GUtil;

public class DefaultTestLogging
implements TestLogging {
    private Set<TestLogEvent> events = EnumSet.noneOf(TestLogEvent.class);
    private int minGranularity = -1;
    private int maxGranularity = -1;
    private int displayGranularity = 2;
    private boolean showExceptions = true;
    private boolean showCauses = true;
    private boolean showStackTraces = true;
    private TestExceptionFormat exceptionFormat = TestExceptionFormat.FULL;
    private Set<TestStackTraceFilter> stackTraceFilters = EnumSet.of(TestStackTraceFilter.TRUNCATE);

    @Override
    public Set<TestLogEvent> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(Set<TestLogEvent> events) {
        this.events = EnumSet.copyOf(events);
    }

    @Override
    public void setEvents(Iterable<?> events) {
        this.events = GUtil.toEnumSet(TestLogEvent.class, events);
    }

    @Override
    public void events(Object ... events) {
        this.events.addAll(GUtil.toEnumSet(TestLogEvent.class, (Object[])events));
    }

    @Override
    public int getMinGranularity() {
        return this.minGranularity;
    }

    @Override
    public void setMinGranularity(int granularity) {
        this.minGranularity = granularity;
    }

    @Override
    public int getMaxGranularity() {
        return this.maxGranularity;
    }

    @Override
    public void setMaxGranularity(int granularity) {
        this.maxGranularity = granularity;
    }

    @Override
    public int getDisplayGranularity() {
        return this.displayGranularity;
    }

    @Override
    public void setDisplayGranularity(int granularity) {
        this.displayGranularity = granularity;
    }

    @Override
    public boolean getShowExceptions() {
        return this.showExceptions;
    }

    @Override
    public void setShowExceptions(boolean flag) {
        this.showExceptions = flag;
    }

    @Override
    public boolean getShowCauses() {
        return this.showCauses;
    }

    @Override
    public void setShowCauses(boolean flag) {
        this.showCauses = flag;
    }

    @Override
    public boolean getShowStackTraces() {
        return this.showStackTraces;
    }

    @Override
    public void setShowStackTraces(boolean flag) {
        this.showStackTraces = flag;
    }

    @Override
    public TestExceptionFormat getExceptionFormat() {
        return this.exceptionFormat;
    }

    @Override
    public void setExceptionFormat(TestExceptionFormat exceptionFormat) {
        this.setExceptionFormat((Object)exceptionFormat);
    }

    @Override
    public void setExceptionFormat(Object exceptionFormat) {
        this.exceptionFormat = (TestExceptionFormat)GUtil.toEnum(TestExceptionFormat.class, (Object)exceptionFormat);
    }

    @Override
    public Set<TestStackTraceFilter> getStackTraceFilters() {
        return this.stackTraceFilters;
    }

    @Override
    public void setStackTraceFilters(Set<TestStackTraceFilter> stackTraceFilters) {
        this.stackTraceFilters = EnumSet.copyOf(stackTraceFilters);
    }

    @Override
    public void setStackTraceFilters(Iterable<?> filters) {
        this.stackTraceFilters = GUtil.toEnumSet(TestStackTraceFilter.class, filters);
    }

    @Override
    public void stackTraceFilters(Object ... filters) {
        this.stackTraceFilters.addAll(GUtil.toEnumSet(TestStackTraceFilter.class, (Object[])filters));
    }

    @Override
    public boolean getShowStandardStreams() {
        return this.events.contains((Object)TestLogEvent.STANDARD_OUT) && this.events.contains((Object)TestLogEvent.STANDARD_ERROR);
    }

    @Override
    public TestLogging setShowStandardStreams(boolean flag) {
        if (flag) {
            this.events.addAll(EnumSet.of(TestLogEvent.STANDARD_OUT, TestLogEvent.STANDARD_ERROR));
        } else {
            this.events.removeAll(EnumSet.of(TestLogEvent.STANDARD_OUT, TestLogEvent.STANDARD_ERROR));
        }
        return this;
    }
}

