/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;
import org.gradle.util.Configurable;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.CollectionUtils;

public class ConfigureUtil {
    public static <T> T configureByMap(Map<?, ?> properties, T delegate) {
        if (properties.isEmpty()) {
            return delegate;
        }
        DynamicObject dynamicObject = DynamicObjectUtil.asDynamicObject(delegate);
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            Object value;
            String name = entry.getKey().toString();
            DynamicInvokeResult result = dynamicObject.trySetProperty(name, value = entry.getValue());
            if (result.isFound()) continue;
            result = dynamicObject.tryInvokeMethod(name, new Object[]{value});
            if (result.isFound()) continue;
            throw dynamicObject.setMissingProperty(name);
        }
        return delegate;
    }

    public static <T> T configureByMap(Map<?, ?> properties, T delegate, Collection<?> mandatoryKeys) {
        if (!mandatoryKeys.isEmpty()) {
            List missingKeys = CollectionUtils.toStringList(mandatoryKeys);
            missingKeys.removeAll(CollectionUtils.toStringList(properties.keySet()));
            if (!missingKeys.isEmpty()) {
                throw new IncompleteInputException("Input configuration map does not contain following mandatory keys: " + missingKeys, missingKeys);
            }
        }
        return ConfigureUtil.configureByMap(properties, delegate);
    }

    public static <T> T configure(@Nullable Closure configureClosure, T target) {
        if (configureClosure == null) {
            return target;
        }
        if (target instanceof Configurable) {
            ((Configurable)target).configure(configureClosure);
        } else {
            ConfigureUtil.configureTarget(configureClosure, target, new ConfigureDelegate(configureClosure, target));
        }
        return target;
    }

    public static <T> Action<T> configureUsing(@Nullable Closure configureClosure) {
        if (configureClosure == null) {
            return Actions.doNothing();
        }
        return new WrappedConfigureAction(configureClosure);
    }

    public static <T> T configureSelf(@Nullable Closure configureClosure, T target) {
        if (configureClosure == null) {
            return target;
        }
        ConfigureUtil.configureTarget(configureClosure, target, new ConfigureDelegate(configureClosure, target));
        return target;
    }

    public static <T> T configureSelf(@Nullable Closure configureClosure, T target, ConfigureDelegate closureDelegate) {
        if (configureClosure == null) {
            return target;
        }
        ConfigureUtil.configureTarget(configureClosure, target, closureDelegate);
        return target;
    }

    private static <T> void configureTarget(Closure configureClosure, T target, ConfigureDelegate closureDelegate) {
        if (!(configureClosure instanceof GeneratedClosure)) {
            new ClosureBackedAction<T>(configureClosure, 1, false).execute(target);
            return;
        }
        Closure withNewOwner = configureClosure.rehydrate(target, (Object)closureDelegate, configureClosure.getThisObject());
        new ClosureBackedAction<T>(withNewOwner, 2, false).execute(target);
    }

    public static class WrappedConfigureAction<T>
    implements Action<T> {
        private final Closure configureClosure;

        WrappedConfigureAction(Closure configureClosure) {
            this.configureClosure = configureClosure;
        }

        public void execute(T t) {
            ConfigureUtil.configure(this.configureClosure, t);
        }

        public Closure getConfigureClosure() {
            return this.configureClosure;
        }
    }

    public static class IncompleteInputException
    extends RuntimeException {
        private final Collection missingKeys;

        public IncompleteInputException(String message, Collection missingKeys) {
            super(message);
            this.missingKeys = missingKeys;
        }

        public Collection getMissingKeys() {
            return this.missingKeys;
        }
    }
}

