/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightAnnotationsValuesKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteral;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0006H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0015\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightPsiLiteral;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiLiteralExpression;", "kotlinOrigin", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lightParent", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;)V", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getParent", "getReference", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiReference;", "getReferences", "", "()[Lcom/intellij/psi/PsiReference;", "getType", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiType;", "getValue", "", "isPhysical", "", "replace", "newElement", "light-classes"})
public class KtLightPsiLiteral
extends KtLightElementBase
implements PsiLiteralExpression {
    @NotNull
    private final KtExpression kotlinOrigin;
    @NotNull
    private final PsiElement lightParent;

    public KtLightPsiLiteral(@NotNull KtExpression kotlinOrigin2, @NotNull PsiElement lightParent) {
        Intrinsics.checkNotNullParameter((Object)kotlinOrigin2, (String)"kotlinOrigin");
        Intrinsics.checkNotNullParameter((Object)lightParent, (String)"lightParent");
        super(lightParent);
        this.kotlinOrigin = kotlinOrigin2;
        this.lightParent = lightParent;
    }

    @Override
    @NotNull
    public KtExpression getKotlinOrigin() {
        return this.kotlinOrigin;
    }

    @Override
    @Nullable
    public Object getValue() {
        return LightClassUtilsKt.computeExpression(this);
    }

    @Override
    @Nullable
    public PsiType getType() {
        FqName fqName2;
        String string2;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"this.project");
        BindingContext bindingContext = LightClassGenerationSupport.Companion.getInstance(project).analyze(this.getKotlinOrigin());
        KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.EXPECTED_EXPRESSION_TYPE, this.getKotlinOrigin());
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        KotlinType kotlinType3 = kotlinType2;
        ClassifierDescriptor classifierDescriptor = kotlinType3.getConstructor().getDeclarationDescriptor();
        String string3 = classifierDescriptor == null ? null : (string2 = (fqName2 = DescriptorUtilsKt.getFqNameSafe(classifierDescriptor)) == null ? null : fqName2.asString());
        if (string2 == null) {
            return null;
        }
        KotlinType typeFqName2 = kotlinType = string2;
        return KtLightAnnotationsValuesKt.psiType$default((String)((Object)typeFqName2), this.getKotlinOrigin(), false, 4, null);
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightParent;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement replace(@NotNull PsiElement newElement) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        PsiLiteral psiLiteral = newElement instanceof PsiLiteral ? (PsiLiteral)newElement : null;
        Object object = psiLiteral == null ? null : psiLiteral.getValue();
        String string3 = string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            return this;
        }
        String value2 = string2;
        this.getKotlinOrigin().replace(KtPsiFactoryKt.KtPsiFactory$default(this, false, 2, null).createExpression('\"' + StringUtil.escapeStringCharacters(value2) + '\"'));
        return this;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        return (PsiReference)ArraysKt.singleOrNull((Object[])this.getReferences());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getKotlinOrigin().getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"kotlinOrigin.references");
        return psiReferenceArray;
    }
}

