/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

class DefaultMutableAttributeContainer
implements AttributeContainerInternal {
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final AttributeContainerInternal parent;
    private ImmutableAttributes state = ImmutableAttributes.EMPTY;
    private Map<Attribute<?>, Provider<?>> lazyAttributes = (Map)Cast.uncheckedCast((Object)Collections.EMPTY_MAP);

    public DefaultMutableAttributeContainer(ImmutableAttributesFactory immutableAttributesFactory) {
        this(immutableAttributesFactory, null);
    }

    public DefaultMutableAttributeContainer(ImmutableAttributesFactory immutableAttributesFactory, @Nullable AttributeContainerInternal parent) {
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.parent = parent;
    }

    public String toString() {
        return this.asImmutable().toString();
    }

    public Set<Attribute<?>> keySet() {
        if (this.parent == null) {
            return this.nonParentKeys();
        }
        return Sets.union((Set)this.parent.keySet(), this.nonParentKeys());
    }

    private Set<Attribute<?>> nonParentKeys() {
        return Sets.union(this.state.keySet(), this.lazyAttributes.keySet());
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.checkInsertionAllowed(key);
        this.doInsertion(key, value);
        return this;
    }

    private <T> void doInsertion(Attribute<T> key, T value) {
        this.assertAttributeValueIsNotNull(value);
        this.assertAttributeTypeIsValid(value.getClass(), key);
        this.state = this.immutableAttributesFactory.concat(this.state, key, value);
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        Class valueType;
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(provider);
        if (provider instanceof ProviderInternal && (valueType = ((ProviderInternal)Cast.uncheckedCast(provider)).getType()) != null) {
            this.assertAttributeTypeIsValid(valueType, key);
        }
        this.addLazyAttribute(key, provider);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        for (Attribute<?> attribute : this.nonParentKeys()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException("Cannot have two attributes with the same name but different types. This container already has an attribute named '" + name + "' of type '" + attribute.getType().getName() + "' and you are trying to store another one of type '" + key.getType().getName() + "'");
        }
    }

    private <T> void assertAttributeTypeIsValid(Class<?> valueType, Attribute<T> attribute) {
        if (!attribute.getType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", attribute.getName(), attribute.getType().getName(), valueType.getName()));
        }
    }

    private void assertAttributeValueIsNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
    }

    public <T> T getAttribute(Attribute<T> key) {
        Object attribute = this.state.getAttribute(key);
        if (attribute == null && this.lazyAttributes.containsKey(key)) {
            attribute = this.realizeLazyAttribute(key);
        }
        if (attribute == null && this.parent != null) {
            attribute = this.parent.getAttribute(key);
        }
        return (T)attribute;
    }

    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    public boolean contains(Attribute<?> key) {
        return this.keySet().contains(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        this.realizeAllLazyAttributes();
        if (this.parent == null) {
            return this.state;
        }
        ImmutableAttributes attributes = this.parent.asImmutable();
        if (!this.state.isEmpty()) {
            attributes = this.immutableAttributesFactory.concat(attributes, this.state);
        }
        return attributes;
    }

    @Override
    public Map<Attribute<?>, ?> asMap() {
        return this.asImmutable().asMap();
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        if (!Objects.equals(this.parent, that.parent)) {
            return false;
        }
        if (!Objects.equals(this.asImmutable(), that.asImmutable())) {
            return false;
        }
        return this.state.equals(that.state);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.asImmutable().hashCode();
        return result;
    }

    private <T> void addLazyAttribute(Attribute<T> key, Provider<? extends T> provider) {
        if (this.lazyAttributes == Collections.EMPTY_MAP) {
            this.lazyAttributes = new LinkedHashMap(1);
        }
        this.lazyAttributes.put(key, provider);
    }

    private <T> T realizeLazyAttribute(Attribute<T> key) {
        Provider<T> provider = this.removeLazyAttribute(key);
        Object value = provider.get();
        this.attribute(key, value);
        return (T)value;
    }

    private void realizeAllLazyAttributes() {
        if (!this.lazyAttributes.isEmpty()) {
            this.lazyAttributes.forEach((key, value) -> this.doInsertion((Attribute)Cast.uncheckedNonnullCast((Object)key), value.get()));
            this.lazyAttributes.clear();
        }
    }

    private <T> Provider<? extends T> removeLazyAttribute(Attribute<T> key) {
        return (Provider)Cast.uncheckedNonnullCast(this.lazyAttributes.remove(key));
    }
}

