/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.snapshot.impl.IsolatableSerializerRegistry;
import org.gradle.internal.snapshot.impl.WorkSerializationException;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.WorkerRequirement;

public class DefaultActionExecutionSpecFactory
implements ActionExecutionSpecFactory {
    private final IsolatableFactory isolatableFactory;
    private final IsolatableSerializerRegistry serializerRegistry;

    public DefaultActionExecutionSpecFactory(IsolatableFactory isolatableFactory, IsolatableSerializerRegistry serializerRegistry) {
        this.isolatableFactory = isolatableFactory;
        this.serializerRegistry = serializerRegistry;
    }

    @Override
    public <T extends WorkParameters> TransportableActionExecutionSpec newTransportableSpec(IsolatedParametersActionExecutionSpec<T> spec) {
        return new TransportableActionExecutionSpec(spec.getImplementationClass().getName(), this.serializerRegistry.serialize(spec.getIsolatedParams()), spec.getClassLoaderStructure(), spec.getBaseDir(), spec.getProjectCacheDir(), spec.isInternalServicesRequired());
    }

    @Override
    public <T extends WorkParameters> IsolatedParametersActionExecutionSpec<T> newIsolatedSpec(String displayName, Class<? extends WorkAction<T>> implementationClass, T params, WorkerRequirement workerRequirement, boolean usesInternalServices) {
        ClassLoaderStructure classLoaderStructure = workerRequirement instanceof IsolatedClassLoaderWorkerRequirement ? ((IsolatedClassLoaderWorkerRequirement)workerRequirement).getClassLoaderStructure() : null;
        return new IsolatedParametersActionExecutionSpec(implementationClass, displayName, implementationClass.getName(), this.isolatableFactory.isolate(params), classLoaderStructure, workerRequirement.getWorkerDirectory(), workerRequirement.getProjectCacheDir(), usesInternalServices);
    }

    @Override
    public <T extends WorkParameters> SimpleActionExecutionSpec<T> newSimpleSpec(IsolatedParametersActionExecutionSpec<T> spec) {
        WorkParameters params = (WorkParameters)Cast.uncheckedCast((Object)spec.getIsolatedParams().isolate());
        return new SimpleActionExecutionSpec<WorkParameters>(spec.getImplementationClass(), params, spec.isInternalServicesRequired());
    }

    @Override
    public <T extends WorkParameters> SimpleActionExecutionSpec<T> newSimpleSpec(TransportableActionExecutionSpec spec) {
        WorkParameters params = (WorkParameters)Cast.uncheckedCast((Object)this.serializerRegistry.deserialize(spec.getSerializedParameters()).isolate());
        return new SimpleActionExecutionSpec<WorkParameters>((Class)Cast.uncheckedCast(DefaultActionExecutionSpecFactory.fromClassName(spec.getImplementationClassName())), params, spec.isInternalServicesRequired());
    }

    static Class<?> fromClassName(String className) {
        try {
            return ClassLoaderUtils.classFromContextLoader((String)className);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work.", (Throwable)e);
        }
    }
}

