/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableList;
import org.gradle.api.Describable;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DescriptiveChange;
import org.gradle.internal.snapshot.impl.ClassImplementationSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class ImplementationChanges
implements ChangeContainer {
    private final ClassImplementationSnapshot previousImplementation;
    private final ImmutableList<ImplementationSnapshot> previousAdditionalImplementations;
    private final ClassImplementationSnapshot currentImplementation;
    private final ImmutableList<ImplementationSnapshot> currentAdditionalImplementations;
    private final Describable executable;

    public ImplementationChanges(ClassImplementationSnapshot previousImplementation, ImmutableList<ImplementationSnapshot> previousAdditionalImplementations, ClassImplementationSnapshot currentImplementation, ImmutableList<ImplementationSnapshot> currentAdditionalImplementations, Describable executable) {
        this.previousImplementation = previousImplementation;
        this.previousAdditionalImplementations = previousAdditionalImplementations;
        this.currentImplementation = currentImplementation;
        this.currentAdditionalImplementations = currentAdditionalImplementations;
        this.executable = executable;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        if (!this.currentImplementation.getClassIdentifier().equals(this.previousImplementation.getClassIdentifier())) {
            return visitor.visitChange(new DescriptiveChange("The type of %s has changed from '%s' to '%s'.", this.executable.getDisplayName(), this.previousImplementation.getClassIdentifier(), this.currentImplementation.getClassIdentifier()));
        }
        if (!this.currentImplementation.getClassLoaderHash().equals((Object)this.previousImplementation.getClassLoaderHash())) {
            return visitor.visitChange(new DescriptiveChange("Class path of %s has changed from %s to %s.", this.executable.getDisplayName(), this.previousImplementation.getClassLoaderHash(), this.currentImplementation.getClassLoaderHash()));
        }
        if (!this.currentAdditionalImplementations.equals(this.previousAdditionalImplementations)) {
            return visitor.visitChange(new DescriptiveChange("One or more additional actions for %s have changed.", this.executable.getDisplayName()));
        }
        return true;
    }
}

