/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileNotationConverter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.UriNotationConverter;
import org.gradle.internal.FileUtils;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TransformingConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.internal.DeferredUtil;

public abstract class AbstractFileResolver
implements FileResolver {
    private final NotationParser<Object, File> fileNotationParser = FileNotationConverter.parser();
    private final NotationParser<Object, URI> uriOrFileNotationParser = NotationParserBuilder.toType(URI.class).typeDisplayName("a URI or File").noImplicitConverters().converter((NotationConverter)new UriNotationConverter()).converter((NotationConverter)new TransformingConverter((NotationConverter)new FileNotationConverter(), file -> this.resolveFile((File)file, PathValidation.NONE).toURI())).toComposite();

    protected AbstractFileResolver() {
    }

    public FileResolver withBaseDir(Object path) {
        return new BaseDirFileResolver(this.resolve(path));
    }

    @Override
    public FileResolver newResolver(File baseDir) {
        return new BaseDirFileResolver(baseDir);
    }

    public File resolve(Object path) {
        return this.resolve(path, PathValidation.NONE);
    }

    @Override
    public NotationParser<Object, File> asNotationParser() {
        return new NotationParser<Object, File>(){

            public File parseNotation(Object notation) throws UnsupportedNotationException {
                return AbstractFileResolver.this.resolve(notation, PathValidation.NONE);
            }

            public void describe(DiagnosticsVisitor visitor) {
                visitor.candidate("Anything that can be converted to a file, as per Project.file()");
            }
        };
    }

    public String resolveForDisplay(Object path) {
        return this.resolveAsRelativePath(path);
    }

    @Override
    public File resolve(Object path, PathValidation validation) {
        File maybeRelativeFile = AbstractFileResolver.unpackAndParseNotation(path, this.fileNotationParser, "File");
        return this.resolveFile(maybeRelativeFile, validation);
    }

    @Override
    public URI resolveUri(Object uri) {
        return AbstractFileResolver.unpackAndParseNotation(uri, this.uriOrFileNotationParser, "URI");
    }

    private static <T> T unpackAndParseNotation(Object input, NotationParser<Object, T> parser, String hint) {
        Object unpacked = DeferredUtil.unpack((Object)input);
        if (unpacked == null || "".equals(unpacked)) {
            throw new IllegalArgumentException(String.format("Cannot convert '%s' to %s.", input, hint));
        }
        return (T)parser.parseNotation(unpacked);
    }

    protected abstract File doResolve(File var1);

    private File resolveFile(File maybeRelativeFile, PathValidation validation) {
        File file = this.doResolve(maybeRelativeFile);
        file = FileUtils.normalize((File)file);
        this.validate(file, validation);
        return file;
    }

    protected void validate(File file, PathValidation validation) {
        switch (validation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }
}

