/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.exceptions.MarkedVerificationException;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.plugins.quality.internal.CodeNarcActionParameters;
import org.gradle.internal.logging.ConsoleRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CodeNarcInvoker
implements Action<AntBuilderDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeNarcInvoker.class);
    private final CodeNarcActionParameters parameters;

    CodeNarcInvoker(CodeNarcActionParameters parameters) {
        this.parameters = parameters;
    }

    public void execute(AntBuilderDelegate ant) {
        ConfigurableFileCollection compilationClasspath = this.parameters.getCompilationClasspath();
        RegularFile configFile = (RegularFile)this.parameters.getConfig().get();
        int maxPriority1Violations = (Integer)this.parameters.getMaxPriority1Violations().get();
        int maxPriority2Violations = (Integer)this.parameters.getMaxPriority2Violations().get();
        int maxPriority3Violations = (Integer)this.parameters.getMaxPriority3Violations().get();
        List reports = (List)this.parameters.getEnabledReports().get();
        boolean ignoreFailures = (Boolean)this.parameters.getIgnoreFailures().get();
        ConfigurableFileCollection source = this.parameters.getSource();
        CodeNarcInvoker.setLifecycleLogLevel(ant, null);
        ant.taskdef((Map)ImmutableMap.of((Object)"name", (Object)"codenarc", (Object)"classname", (Object)"org.codenarc.ant.CodeNarcTask"));
        try {
            ant.invokeMethod("codenarc", (Map)ImmutableMap.of((Object)"ruleSetFiles", (Object)("file:" + configFile), (Object)"maxPriority1Violations", (Object)maxPriority1Violations, (Object)"maxPriority2Violations", (Object)maxPriority2Violations, (Object)"maxPriority3Violations", (Object)maxPriority3Violations), () -> CodeNarcInvoker.lambda$execute$4(reports, ant, (FileCollection)source, (FileCollection)compilationClasspath));
        }
        catch (Exception e) {
            if (e.getMessage().matches("Exceeded maximum number of priority \\d* violations.*")) {
                String message = "CodeNarc rule violations were found.";
                List reportsWithFiles = reports.stream().filter(it -> !((String)it.getName().get()).equals("console")).collect(Collectors.toList());
                if (!reportsWithFiles.isEmpty()) {
                    CodeNarcActionParameters.EnabledReport humanReadableReport = reportsWithFiles.stream().filter(it -> ((String)it.getName().get()).equals("html")).findFirst().orElse(null);
                    if (humanReadableReport == null) {
                        humanReadableReport = reportsWithFiles.stream().filter(it -> ((String)it.getName().get()).equals("text")).findFirst().orElse(null);
                    }
                    if (humanReadableReport == null) {
                        humanReadableReport = reportsWithFiles.stream().filter(it -> ((String)it.getName().get()).equals("xml")).findFirst().orElse(null);
                    }
                    if (humanReadableReport != null) {
                        String reportUrl = new ConsoleRenderer().asClickableFileUrl((File)humanReadableReport.getOutputLocation().getAsFile().get());
                        message = message + " See the report at: " + reportUrl;
                    }
                }
                if (ignoreFailures) {
                    LOGGER.warn(message);
                    return;
                }
                throw new MarkedVerificationException(message, (Throwable)e);
            }
            if (e.getMessage().contains("codenarc doesn't support the nested \"classpath\" element.")) {
                String message = "The compilationClasspath property of CodeNarc task can only be non-empty when using CodeNarc 0.27.0 or newer.";
                throw new GradleException(message, (Throwable)e);
            }
            throw e;
        }
    }

    static void setLifecycleLogLevel(AntBuilderDelegate ant, @Nullable String lifecycleLogLevel) {
        try {
            Object project = ant.getBuilder().getClass().getMethod("getProject", new Class[0]).invoke(ant.getBuilder(), new Object[0]);
            List buildListeners = (List)project.getClass().getMethod("getBuildListeners", new Class[0]).invoke(project, new Object[0]);
            for (Object it : buildListeners) {
                if (!it.getClass().getName().equals(AntLoggingAdapter.class.getName())) continue;
                it.getClass().getMethod("setLifecycleLogLevel", String.class).invoke(it, lifecycleLogLevel);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$execute$4(List reports, AntBuilderDelegate ant, FileCollection source, FileCollection compilationClasspath) {
        reports.forEach(r -> {
            if (((String)r.getName().get()).equals("console")) {
                CodeNarcInvoker.setLifecycleLogLevel(ant, "INFO");
                ant.invokeMethod("report", (Map)ImmutableMap.of((Object)"type", (Object)"ide"), () -> ant.invokeMethod("option", (Object)ImmutableMap.of((Object)"name", (Object)"writeToStandardOut", (Object)"value", (Object)true)));
            } else if (((String)r.getName().get()).equals("html")) {
                ant.invokeMethod("report", (Map)ImmutableMap.of((Object)"type", (Object)"sortable"), () -> ant.invokeMethod("option", (Object)ImmutableMap.of((Object)"name", (Object)"outputFile", (Object)"value", (Object)((Serializable)r.getOutputLocation().getAsFile().get()))));
            } else {
                ant.invokeMethod("report", (Map)ImmutableMap.of((Object)"type", (Object)r.getName().get()), () -> ant.invokeMethod("option", (Object)ImmutableMap.of((Object)"name", (Object)"outputFile", (Object)"value", (Object)((Serializable)r.getOutputLocation().getAsFile().get()))));
            }
        });
        source.addToAntBuilder((Object)ant, "fileset", FileCollection.AntType.FileSet);
        if (!compilationClasspath.isEmpty()) {
            compilationClasspath.addToAntBuilder((Object)ant, "classpath");
        }
    }
}

