/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.AbstractBundle;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.util.DefaultBundleService;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Attribute;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    @NotNull
    private static String ourLangTag = Locale.ENGLISH.toLanguageTag();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
    }

    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        return DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, loader -> super.findBundle(pathToBundle, (ClassLoader)loader, control));
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull @NotNull Function<? super @NotNull ClassLoader, ? extends @NotNull ResourceBundle> bundleResolver) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(8);
        }
        ResourceBundle base = bundleResolver.apply(baseLoader);
        ClassLoader pluginClassLoader = DynamicBundle.languagePluginClassLoader(bundleClassLoader);
        if (pluginClassLoader == null) {
            ResourceBundle resourceBundle = base;
            if (resourceBundle == null) {
                DynamicBundle.$$$reportNull$$$0(9);
            }
            return resourceBundle;
        }
        ResourceBundle pluginBundle = bundleResolver.apply(pluginClassLoader);
        if (!DynamicBundle.setBundleParent(pluginBundle, base)) {
            ResourceBundle resourceBundle = base;
            if (resourceBundle == null) {
                DynamicBundle.$$$reportNull$$$0(10);
            }
            return resourceBundle;
        }
        ResourceBundle resourceBundle = pluginBundle;
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(11);
        }
        return resourceBundle;
    }

    @Nullable
    private static ClassLoader languagePluginClassLoader(@NotNull ClassLoader bundleClassLoader) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(12);
        }
        if (DefaultBundleService.isDefaultBundle()) {
            return null;
        }
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return null;
        }
        PluginDescriptor pluginDescriptor = langBundle.pluginDescriptor;
        return pluginDescriptor == null ? bundleClassLoader : pluginDescriptor.getClassLoader();
    }

    private static boolean setBundleParent(@NotNull ResourceBundle pluginBundle, ResourceBundle base) {
        if (pluginBundle == null) {
            DynamicBundle.$$$reportNull$$$0(13);
        }
        if (pluginBundle == base) {
            return true;
        }
        try {
            if (DynamicBundleInternal.SET_PARENT != null) {
                DynamicBundleInternal.SET_PARENT.bindTo(pluginBundle).invoke(base);
            }
            return true;
        }
        catch (Throwable e) {
            LOG.warn(e);
            return false;
        }
    }

    @Nullable
    public static LanguageBundleEP findLanguageBundle() {
        try {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || !app.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClassLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleResolver";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/DynamicBundle";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginBundle";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/DynamicBundle";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "bundleResolver";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 28: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "languagePluginClassLoader";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setBundleParent";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPluginBundle";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "bundleResolver";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("org.jetbrains.kotlin.com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        public PluginDescriptor pluginDescriptor;

        @Override
        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }

    private static class DynamicBundleInternal {
        private static final MethodHandle SET_PARENT;

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

