/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class MethodResolveProcessor
implements ElementClassHint,
NameHint,
PsiScopeProcessor {
    private final String myNameHint;
    private final List<PsiMethod> myMethods = new ArrayList<PsiMethod>();

    public MethodResolveProcessor() {
        this.myNameHint = null;
    }

    public MethodResolveProcessor(String name2) {
        this.myNameHint = name2;
    }

    public PsiMethod[] getMethods() {
        return this.myMethods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            MethodResolveProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            MethodResolveProcessor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull(this.myMethods, (PsiMethod)element);
        }
        return true;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            MethodResolveProcessor.$$$reportNull$$$0(2);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == NameHint.KEY && this.myNameHint != null) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        if (kind == null) {
            MethodResolveProcessor.$$$reportNull$$$0(3);
        }
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    public static PsiMethod[] findMethod(PsiClass psiClass, String methodName) {
        MethodResolveProcessor processor = new MethodResolveProcessor(methodName);
        psiClass.processDeclarations(processor, ResolveState.initial(), null, psiClass);
        return processor.getMethods();
    }

    public static PsiMethod[] getAllMethods(PsiClass psiClass) {
        MethodResolveProcessor processor = new MethodResolveProcessor();
        psiClass.processDeclarations(processor, ResolveState.initial(), null, psiClass);
        return processor.getMethods();
    }

    @Override
    @Nullable
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            MethodResolveProcessor.$$$reportNull$$$0(4);
        }
        return this.myNameHint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

