/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.MultipleContextReceiversApplicableForExtensionReceivers;
import org.jetbrains.kotlin.fir.resolve.calls.NoReceiverAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ArgumentCheckingProcessor;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ReceiverDescription;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ<\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0014*\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveExtensionReceiver", "receivers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ReceiverDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpectedReceiverType", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSinkKt\n*L\n1#1,879:1\n1557#2:880\n1628#2,3:881\n774#2:884\n865#2,2:885\n29#3,2:887\n23#3,9:889\n29#3,2:898\n23#3,9:900\n23#3,4:909\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n*L\n97#1:880\n97#1:881,3\n106#1:884\n106#1:885,2\n111#1:887,2\n111#1:889,9\n113#1:898,2\n113#1:900,9\n139#1:909,4\n*E\n"})
public final class CheckExtensionReceiver
extends ResolutionStage {
    @NotNull
    public static final CheckExtensionReceiver INSTANCE = new CheckExtensionReceiver();

    private CheckExtensionReceiver() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        ResolutionDiagnostic diagnostic$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        FirElement callSite = callInfo.getCallSite();
        if (callSite instanceof FirImplicitInvokeCall) {
            boolean isInvokeFromExtensionFunctionType = ResolutionStagesKt.isInvokeFromExtensionFunctionType(candidate2);
            boolean isImplicitInvokeCallWithExplicitReceiver = ((FirImplicitInvokeCall)callSite).isCallWithExplicitReceiver();
            if (!isInvokeFromExtensionFunctionType && isImplicitInvokeCallWithExplicitReceiver) {
                sink.reportDiagnostic(NoReceiverAllowed.INSTANCE);
            }
        }
        ConeKotlinType coneKotlinType = this.getExpectedReceiverType(candidate2);
        if (coneKotlinType == null) {
            return Unit.INSTANCE;
        }
        ConeKotlinType expectedReceiverType = coneKotlinType;
        ConeKotlinType expectedType = candidate2.getSubstitutor().substituteOrSelf(expectedReceiverType.getType());
        if (candidate2.getGivenExtensionReceiverOptions().isEmpty()) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = candidate2.getGivenExtensionReceiverOptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirExpression firExpression = (FirExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ResolutionStagesKt.access$prepareReceivers(candidate2, (FirExpression)it, expectedType, context));
        }
        List preparedReceivers = (List)destination$iv$iv;
        if (preparedReceivers.size() == 1) {
            Object object = this.resolveExtensionReceiver(preparedReceivers, candidate2, expectedType, sink, context, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Iterable $this$filter$iv = preparedReceivers;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReceiverDescription it = (ReceiverDescription)element$iv$iv;
            boolean bl = false;
            if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(candidate2.getSystem(), it.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List successfulReceivers = (List)destination$iv$iv2;
        switch (successfulReceivers.size()) {
            case 0: {
                void $this$yieldDiagnostic$iv;
                CheckerSink $i$f$filter2 = sink;
                diagnostic$iv = new InapplicableWrongReceiver(null, null, 3, null);
                boolean $i$f$yieldDiagnostic = false;
                $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
                void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
                boolean $i$f$yieldIfNeed = false;
                if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                    Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                }
                return Unit.INSTANCE;
            }
            case 1: {
                Object object = this.resolveExtensionReceiver(successfulReceivers, candidate2, expectedType, sink, context, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        CheckerSink $this$yieldDiagnostic$iv = sink;
        diagnostic$iv = new MultipleContextReceiversApplicableForExtensionReceivers();
        boolean $i$f$yieldDiagnostic = false;
        $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
        CheckerSink $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final Object resolveExtensionReceiver(List<ReceiverDescription> receivers, Candidate candidate2, ConeKotlinType expectedType, CheckerSink sink, ResolutionContext context, Continuation<? super Unit> $completion) {
        ReceiverDescription receiver = (ReceiverDescription)CollectionsKt.single(receivers);
        ArgumentCheckingProcessor.INSTANCE.resolvePlainArgumentType(candidate2, receiver.getExpression(), receiver.getType(), expectedType, sink, context, true, false, candidate2.getCallInfo().getCallSite().getSource());
        candidate2.setChosenExtensionReceiver(receiver.getExpression());
        CheckerSink $this$yieldIfNeed$iv = sink;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getExpectedReceiverType(Candidate $this$getExpectedReceiverType) {
        FirBasedSymbol<?> firBasedSymbol = $this$getExpectedReceiverType.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        FirPureAbstractElement firPureAbstractElement = ((FirCallableDeclaration)callableSymbol.getFir()).getReceiverParameter();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null;
    }

    public static final /* synthetic */ Object access$resolveExtensionReceiver(CheckExtensionReceiver $this, List receivers, Candidate candidate2, ConeKotlinType expectedType, CheckerSink sink, ResolutionContext context, Continuation $completion) {
        return $this.resolveExtensionReceiver(receivers, candidate2, expectedType, sink, context, (Continuation<? super Unit>)$completion);
    }
}

