/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmData;
import org.jetbrains.kotlin.wasm.ir.WasmDataMode;
import org.jetbrains.kotlin.wasm.ir.WasmElement;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmLimits;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmMemory;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.WasmNamedModuleField;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmTag;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteWriter;
import org.jetbrains.kotlin.wasm.ir.convertors.SourceLocationMappingToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmBinary;
import org.jetbrains.kotlin.wasm.ir.debug.DebugData;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationConsumer;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationGenerator;
import org.jetbrains.kotlin.wasm.ir.debug.DebugSection;
import org.jetbrains.kotlin.wasm.ir.source.location.Box;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001aJ\u0016\u0010 \u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001cH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J%\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0-H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0016\u00100\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0-H\u0002J\u0010\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001a2\u0006\u00106\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u00106\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u001a2\u0006\u00106\u001a\u00020@H\u0002J\u0010\u0010D\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\"H\u0002J\u0010\u0010K\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u001a2\u0006\u0010U\u001a\u00020VH\u0002J\u0016\u0010W\u001a\u00020\u001a2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020%0YH\u0002J\u0014\u0010Z\u001a\u00020\u001a2\n\u0010[\u001a\u0006\u0012\u0002\b\u00030\\H\u0002J\u0010\u0010]\u001a\u00020\u001a2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\"H\u0002J\u0010\u0010d\u001a\u00020\u001a2\u0006\u0010e\u001a\u00020fH\u0002J\u000e\u0010g\u001a\u00020\u001a2\u0006\u00106\u001a\u00020hJ\u000e\u0010i\u001a\u00020\u001a2\u0006\u00106\u001a\u00020jJ\u000e\u0010k\u001a\u00020\u001a2\u0006\u0010l\u001a\u00020mJ\u000e\u0010n\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020oJ\u0012\u0010p\u001a\u00020\u001a*\u00020\u00152\u0006\u0010q\u001a\u000204J\u0014\u0010r\u001a\u00020\u001a*\u00020\u00152\u0006\u0010s\u001a\u00020\u0007H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010A\u001a\u000204*\u0002078F\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006t"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToBinary;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationConsumer;", "outputStream", "Ljava/io/OutputStream;", "module", "Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "moduleName", "", "emitNameSection", "", "debugInformationGenerator", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;", "<init>", "(Ljava/io/OutputStream;Lorg/jetbrains/kotlin/wasm/ir/WasmModule;Ljava/lang/String;ZLorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;)V", "getModule", "()Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "getModuleName", "()Ljava/lang/String;", "getEmitNameSection", "()Z", "b", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "offsets", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/wasm/ir/source/location/Box;", "consumeDebugInformation", "", "debugInformation", "", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugSection;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformation;", "appendWasmModule", "appendTextSection", "definedFunctions", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "appendInstr", "instr", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "appendImmediate", "x", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "appendSection", "section", "Lorg/jetbrains/kotlin/wasm/ir/convertors/WasmBinary$Section;", "content", "Lkotlin/Function0;", "appendSection-Sr9dMcE", "(SLkotlin/jvm/functions/Function0;)V", "withVarUInt32PayloadSizePrepended", "fn", "appendVectorSize", "size", "", "appendFunctionTypeDeclaration", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "appendBlockType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$BlockType;", "appendFiledType", "field", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "appendStructTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "appendArrayTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmArrayDeclaration;", "index", "getIndex", "(Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;)I", "appendLimits", "limits", "Lorg/jetbrains/kotlin/wasm/ir/WasmLimits;", "appendImportedFunction", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Imported;", "appendDefinedFunction", "appendTable", "table", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "appendMemory", "memory", "Lorg/jetbrains/kotlin/wasm/ir/WasmMemory;", "appendGlobal", "c", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "appendTag", "t", "Lorg/jetbrains/kotlin/wasm/ir/WasmTag;", "appendExpr", "expr", "", "appendExport", "export", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "appendStartFunction", "startFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "appendElement", "element", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement;", "appendCode", "appendData", "wasmData", "Lorg/jetbrains/kotlin/wasm/ir/WasmData;", "appendHeapType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "appendType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "appendLocalReference", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "appendModuleFieldReference", "Lorg/jetbrains/kotlin/wasm/ir/WasmNamedModuleField;", "writeVarUInt32", "v", "writeString", "str", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmIrToBinary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmIrToBinary.kt\norg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToBinary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,750:1\n1863#2,2:751\n1863#2,2:755\n1863#2,2:757\n1863#2,2:760\n1863#2,2:762\n1863#2,2:764\n1863#2,2:766\n1734#2,3:768\n1557#2:771\n1628#2,3:772\n1863#2,2:775\n1863#2,2:777\n1863#2,2:779\n1863#2,2:781\n1863#2,2:783\n1863#2,2:785\n1863#2,2:787\n1863#2,2:789\n1863#2,2:791\n1863#2,2:793\n1863#2,2:795\n1863#2,2:797\n1863#2,2:799\n1863#2:801\n1863#2,2:802\n1864#2:804\n1863#2,2:805\n1863#2,2:807\n808#2,11:809\n1863#2:820\n1872#2,3:821\n1864#2:824\n1863#2,2:825\n1863#2,2:827\n1782#2,4:829\n1863#2,2:833\n1#3:753\n138#4:754\n138#4:759\n*S KotlinDebug\n*F\n+ 1 WasmIrToBinary.kt\norg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToBinary\n*L\n71#1:751,2\n271#1:755,2\n319#1:757,2\n354#1:760,2\n356#1:762,2\n399#1:764,2\n477#1:766,2\n492#1:768,3\n495#1:771\n495#1:772,3\n90#1:775,2\n94#1:777,2\n107#1:779,2\n122#1:781,2\n128#1:783,2\n134#1:785,2\n141#1:787,2\n147#1:789,2\n152#1:791,2\n164#1:793,2\n176#1:795,2\n181#1:797,2\n201#1:799,2\n208#1:801\n211#1:802,2\n208#1:804\n223#1:805,2\n231#1:807,2\n240#1:809,11\n242#1:820\n245#1:821,3\n242#1:824\n501#1:825,2\n503#1:827,2\n555#1:829,4\n556#1:833,2\n256#1:754\n332#1:759\n*E\n"})
public final class WasmIrToBinary
implements DebugInformationConsumer {
    @NotNull
    private final WasmModule module;
    @NotNull
    private final String moduleName;
    private final boolean emitNameSection;
    @Nullable
    private final DebugInformationGenerator debugInformationGenerator;
    @NotNull
    private ByteWriter b;
    @NotNull
    private PersistentList<Box> offsets;

    public WasmIrToBinary(@NotNull OutputStream outputStream, @NotNull WasmModule module2, @NotNull String moduleName, boolean emitNameSection, @Nullable DebugInformationGenerator debugInformationGenerator) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.module = module2;
        this.moduleName = moduleName;
        this.emitNameSection = emitNameSection;
        this.debugInformationGenerator = debugInformationGenerator;
        this.b = new ByteWriter.OutputStream(outputStream);
        this.offsets = ExtensionsKt.persistentListOf();
    }

    public /* synthetic */ WasmIrToBinary(OutputStream outputStream, WasmModule wasmModule, String string2, boolean bl, DebugInformationGenerator debugInformationGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            debugInformationGenerator = null;
        }
        this(outputStream, wasmModule, string2, bl, debugInformationGenerator);
    }

    @NotNull
    public final WasmModule getModule() {
        return this.module;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    public final boolean getEmitNameSection() {
        return this.emitNameSection;
    }

    @Override
    public void consumeDebugInformation(@NotNull List<DebugSection> debugInformation) {
        Intrinsics.checkNotNullParameter(debugInformation, (String)"debugInformation");
        Iterable $this$forEach$iv = debugInformation;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugSection it = (DebugSection)element$iv;
            boolean bl = false;
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getCUSTOM-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.consumeDebugInformation$lambda$1$lambda$0(this, it)));
        }
    }

    public final void appendWasmModule() {
        block4: {
            this.b.writeUInt32-WZ4Q5Ns(1836278016);
            this.b.writeUInt32-WZ4Q5Ns(1);
            WasmModule $this$appendWasmModule_u24lambda_u2428 = this.module;
            boolean bl = false;
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getTYPE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$4($this$appendWasmModule_u24lambda_u2428, this)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getIMPORT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$6(this, $this$appendWasmModule_u24lambda_u2428)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getFUNCTION-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$8(this, $this$appendWasmModule_u24lambda_u2428)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getTABLE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$10(this, $this$appendWasmModule_u24lambda_u2428)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getMEMORY-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$12(this, $this$appendWasmModule_u24lambda_u2428)));
            if (!((Collection)$this$appendWasmModule_u24lambda_u2428.getTags()).isEmpty()) {
                this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getTAG-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$14(this, $this$appendWasmModule_u24lambda_u2428)));
            }
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getGLOBAL-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$16(this, $this$appendWasmModule_u24lambda_u2428)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getEXPORT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$18(this, $this$appendWasmModule_u24lambda_u2428)));
            if ($this$appendWasmModule_u24lambda_u2428.getStartFunction() != null) {
                this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getSTART-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$19(this, $this$appendWasmModule_u24lambda_u2428)));
            }
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getELEMENT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$21(this, $this$appendWasmModule_u24lambda_u2428)));
            if ($this$appendWasmModule_u24lambda_u2428.getDataCount()) {
                this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getDATA_COUNT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$22(this, $this$appendWasmModule_u24lambda_u2428)));
            }
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getCODE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$24(this, $this$appendWasmModule_u24lambda_u2428)));
            this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getDATA-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendWasmModule$lambda$28$lambda$26(this, $this$appendWasmModule_u24lambda_u2428)));
            if (this.emitNameSection) {
                this.appendTextSection($this$appendWasmModule_u24lambda_u2428.getDefinedFunctions());
            }
            DebugInformationGenerator debugInformationGenerator = this.debugInformationGenerator;
            if (debugInformationGenerator == null) break block4;
            DebugInformationGenerator it = debugInformationGenerator;
            boolean bl2 = false;
            this.consumeDebugInformation(it.generateDebugInformation());
        }
    }

    private final void appendTextSection(List<WasmFunction.Defined> definedFunctions) {
        this.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getCUSTOM-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42(this, definedFunctions)));
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInstr(WasmInstr instr) {
        SourceLocation sourceLocation = instr.getLocation();
        if (sourceLocation != null) {
            SourceLocation it = sourceLocation;
            boolean bl = false;
            DebugInformationGenerator debugInformationGenerator = this.debugInformationGenerator;
            if (debugInformationGenerator != null) {
                void $this$plus$iv;
                PersistentList<Box> persistentList = this.offsets;
                Box element$iv = new Box(this.b.getWritten());
                boolean $i$f$plus = false;
                debugInformationGenerator.addSourceLocation(new SourceLocationMappingToBinary(it, (List<Box>)$this$plus$iv.add(element$iv)));
            }
        }
        int opcode = instr.getOperator().getOpcode();
        if (opcode == 65535) {
            return;
        }
        if (opcode > 255) {
            this.b.writeByte((byte)(opcode >>> 8));
            this.b.writeByte((byte)(opcode & 0xFF));
        } else {
            this.b.writeByte((byte)opcode);
        }
        Iterable $this$forEach$iv = instr.getImmediates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmImmediate it = (WasmImmediate)element$iv;
            boolean bl = false;
            this.appendImmediate(it);
        }
    }

    private final void appendImmediate(WasmImmediate x) {
        WasmImmediate wasmImmediate = x;
        if (wasmImmediate instanceof WasmImmediate.ConstU8) {
            this.b.writeUByte-7apg3OU(((WasmImmediate.ConstU8)x).getValue-w2LRezQ());
        } else if (wasmImmediate instanceof WasmImmediate.ConstI32) {
            this.b.writeVarInt32(((WasmImmediate.ConstI32)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ConstI64) {
            this.b.writeVarInt64(((WasmImmediate.ConstI64)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ConstF32) {
            this.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.ConstF32)x).getRawBits-pVg5ArA());
        } else if (wasmImmediate instanceof WasmImmediate.ConstF64) {
            this.b.writeUInt64-VKZWuLQ(((WasmImmediate.ConstF64)x).getRawBits-s-VKNKU());
        } else if (wasmImmediate instanceof WasmImmediate.SymbolI32) {
            this.b.writeVarInt32(((Number)((WasmImmediate.SymbolI32)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.MemArg) {
            this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getAlign-pVg5ArA());
            this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getOffset-pVg5ArA());
        } else if (wasmImmediate instanceof WasmImmediate.BlockType) {
            this.appendBlockType((WasmImmediate.BlockType)x);
        } else if (wasmImmediate instanceof WasmImmediate.FuncIdx) {
            this.appendModuleFieldReference(((WasmImmediate.FuncIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.LocalIdx) {
            this.appendLocalReference(((WasmImmediate.LocalIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.GlobalIdx) {
            this.appendModuleFieldReference(((WasmImmediate.GlobalIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.TypeIdx) {
            this.appendModuleFieldReference(((WasmImmediate.TypeIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.MemoryIdx) {
            this.writeVarUInt32(this.b, ((WasmImmediate.MemoryIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.DataIdx) {
            this.writeVarUInt32(this.b, ((Number)((WasmImmediate.DataIdx)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.TableIdx) {
            this.writeVarUInt32(this.b, ((Number)((WasmImmediate.TableIdx)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdx) {
            this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.TagIdx) {
            this.writeVarUInt32(this.b, ((WasmImmediate.TagIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdxVector) {
            this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdxVector)x).getValue().size());
            Iterator<Integer> iterator2 = ((WasmImmediate.LabelIdxVector)x).getValue().iterator();
            while (iterator2.hasNext()) {
                int target = ((Number)iterator2.next()).intValue();
                this.writeVarUInt32(this.b, target);
            }
        } else if (wasmImmediate instanceof WasmImmediate.ElemIdx) {
            this.appendModuleFieldReference(((WasmImmediate.ElemIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ValTypeVector) {
            this.writeVarUInt32(this.b, ((WasmImmediate.ValTypeVector)x).getValue().size());
            for (WasmType type2 : ((WasmImmediate.ValTypeVector)x).getValue()) {
                this.appendType(type2);
            }
        } else if (wasmImmediate instanceof WasmImmediate.GcType) {
            this.appendModuleFieldReference(((WasmImmediate.GcType)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.StructFieldIdx) {
            this.writeVarUInt32(this.b, ((Number)((WasmImmediate.StructFieldIdx)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.HeapType) {
            this.appendHeapType(((WasmImmediate.HeapType)x).getValue());
        } else {
            if (wasmImmediate instanceof WasmImmediate.ConstString) {
                throw new IllegalStateException("Instructions with pseudo immediates should be skipped".toString());
            }
            if (wasmImmediate instanceof WasmImmediate.Catch) {
                this.writeVarUInt32(this.b, ((WasmImmediate.Catch)x).getType().getOpcode());
                Iterable $this$forEach$iv = ((WasmImmediate.Catch)x).getImmediates();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WasmImmediate p0 = (WasmImmediate)element$iv;
                    boolean bl = false;
                    this.appendImmediate(p0);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void appendSection-Sr9dMcE(short section, Function0<Unit> content) {
        this.b.writeVarUInt7-xj2QHRw(section);
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)() -> WasmIrToBinary.appendSection_Sr9dMcE$lambda$45(content)));
    }

    private final void withVarUInt32PayloadSizePrepended(Function0<Unit> fn) {
        ByteWriter newWriter;
        Box box = new Box(-1);
        PersistentList<Box> previousOffsets = this.offsets;
        PersistentList<Box> $this$plus$iv = this.offsets;
        boolean $i$f$plus = false;
        this.offsets = $this$plus$iv.add(box);
        ByteWriter previousWriter = this.b;
        this.b = newWriter = this.b.createTemp();
        fn.invoke();
        this.b = previousWriter;
        this.writeVarUInt32(this.b, newWriter.getWritten());
        box.setValue(this.b.getWritten());
        this.offsets = previousOffsets;
        this.b.write(newWriter);
    }

    private final void appendVectorSize(int size) {
        this.writeVarUInt32(this.b, size);
    }

    private final void appendFunctionTypeDeclaration(WasmFunctionType type2) {
        WasmType it;
        this.b.writeVarInt7((byte)-32);
        this.writeVarUInt32(this.b, type2.getParameterTypes().size());
        Iterable $this$forEach$iv = type2.getParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
        this.writeVarUInt32(this.b, type2.getResultTypes().size());
        $this$forEach$iv = type2.getResultTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
    }

    private final void appendBlockType(WasmImmediate.BlockType type2) {
        WasmImmediate.BlockType blockType = type2;
        if (blockType instanceof WasmImmediate.BlockType.Function) {
            this.appendModuleFieldReference(((WasmImmediate.BlockType.Function)type2).getType());
        } else if (blockType instanceof WasmImmediate.BlockType.Value) {
            if (((WasmImmediate.BlockType.Value)type2).getType() == null) {
                this.b.writeVarInt7((byte)-64);
            } else {
                this.appendType(((WasmImmediate.BlockType.Value)type2).getType());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void appendFiledType(WasmStructFieldDeclaration field) {
        this.appendType(field.getType());
        this.b.writeVarUInt1(field.isMutable());
    }

    private final void appendStructTypeDeclaration(WasmStructDeclaration type2) {
        WasmSymbolReadOnly<WasmTypeDeclaration> superType = type2.getSuperType();
        if (superType != null || !type2.isFinal()) {
            this.b.writeVarInt7(type2.isFinal() ? (byte)-49 : -48);
            if (superType != null) {
                this.appendVectorSize(1);
                this.appendModuleFieldReference(superType.getOwner());
            } else {
                this.appendVectorSize(0);
            }
        }
        this.b.writeVarInt7((byte)-33);
        this.writeVarUInt32(this.b, type2.getFields().size());
        Iterable $this$forEach$iv = type2.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmStructFieldDeclaration it = (WasmStructFieldDeclaration)element$iv;
            boolean bl = false;
            this.appendFiledType(it);
        }
    }

    private final void appendArrayTypeDeclaration(WasmArrayDeclaration type2) {
        this.b.writeVarInt7((byte)-34);
        this.appendFiledType(type2.getField());
    }

    public final int getIndex(@NotNull WasmFunctionType $this$index) {
        Intrinsics.checkNotNullParameter((Object)$this$index, (String)"<this>");
        Integer n = $this$index.getId();
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    private final void appendLimits(WasmLimits limits) {
        this.b.writeVarUInt1(limits.getMaxSize-0hXNFcg() != null);
        this.b.writeVarUInt32-WZ4Q5Ns(limits.getMinSize-pVg5ArA());
        if (limits.getMaxSize-0hXNFcg() != null) {
            this.b.writeVarUInt32-WZ4Q5Ns(limits.getMaxSize-0hXNFcg().unbox-impl());
        }
    }

    private final void appendImportedFunction(WasmFunction.Imported function2) {
        this.writeString(this.b, function2.getImportPair().getModuleName());
        this.writeString(this.b, function2.getImportPair().getDeclarationName());
        this.b.writeByte((byte)0);
        this.writeVarUInt32(this.b, this.getIndex(function2.getType().getOwner()));
    }

    private final void appendDefinedFunction(WasmFunction.Defined function2) {
        this.writeVarUInt32(this.b, this.getIndex(function2.getType().getOwner()));
    }

    private final void appendTable(WasmTable table) {
        if (table.getImportPair() != null) {
            this.writeString(this.b, table.getImportPair().getModuleName());
            this.writeString(this.b, table.getImportPair().getDeclarationName());
            this.b.writeByte((byte)1);
        }
        this.appendType(table.getElementType());
        this.appendLimits(table.getLimits());
    }

    private final void appendMemory(WasmMemory memory) {
        if (memory.getImportPair() != null) {
            this.writeString(this.b, memory.getImportPair().getModuleName());
            this.writeString(this.b, memory.getImportPair().getDeclarationName());
            this.b.writeByte((byte)2);
        }
        this.appendLimits(memory.getLimits());
    }

    private final void appendGlobal(WasmGlobal c) {
        if (c.getImportPair() != null) {
            this.writeString(this.b, c.getImportPair().getModuleName());
            this.writeString(this.b, c.getImportPair().getDeclarationName());
            this.b.writeByte((byte)3);
            this.appendType(c.getType());
            this.b.writeVarUInt1(c.isMutable());
            return;
        }
        this.appendType(c.getType());
        this.b.writeVarUInt1(c.isMutable());
        this.appendExpr((Iterable<? extends WasmInstr>)c.getInit());
    }

    private final void appendTag(WasmTag t) {
        boolean bl;
        if (t.getImportPair() != null) {
            this.writeString(this.b, t.getImportPair().getModuleName());
            this.writeString(this.b, t.getImportPair().getDeclarationName());
            this.b.writeByte((byte)4);
            return;
        }
        this.b.writeByte((byte)0);
        boolean bl2 = bl = t.getType().getId() != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unlinked tag id";
            throw new AssertionError((Object)string2);
        }
        Integer n = t.getType().getId();
        Intrinsics.checkNotNull((Object)n);
        this.writeVarUInt32(this.b, n);
    }

    private final void appendExpr(Iterable<? extends WasmInstr> expr) {
        Iterable<? extends WasmInstr> $this$forEach$iv = expr;
        boolean $i$f$forEach = false;
        Iterator<? extends WasmInstr> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            WasmInstr element$iv;
            WasmInstr it = element$iv = iterator2.next();
            boolean bl = false;
            this.appendInstr(it);
        }
        this.appendInstr(new WasmInstrWithLocation(WasmOp.END, SourceLocation.Companion.NoLocation("End of instruction list")));
    }

    private final void appendExport(WasmExport<?> export) {
        this.writeString(this.b, export.getName());
        this.b.writeByte(export.getKind());
        this.appendModuleFieldReference((WasmNamedModuleField)export.getField());
    }

    private final void appendStartFunction(WasmFunction startFunction) {
        this.appendModuleFieldReference(startFunction);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendElement(WasmElement element) {
        List list;
        boolean isFuncIndices;
        boolean bl;
        block16: {
            Iterable $this$all$iv = element.getValues();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WasmTable.Value it = (WasmTable.Value)element$iv;
                    boolean bl2 = false;
                    if (it instanceof WasmTable.Value.Function) continue;
                    bl = false;
                    break block16;
                }
                bl = true;
            }
        }
        boolean bl3 = isFuncIndices = bl && Intrinsics.areEqual((Object)element.getType(), (Object)WasmFuncRef.INSTANCE);
        if (isFuncIndices) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            Iterable $this$map$iv = element.getValues();
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WasmTable.Value value2 = (WasmTable.Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmTable.Value.Function");
                Integer n = ((WasmTable.Value.Function)it).getFunction().getOwner().getId();
                Intrinsics.checkNotNull((Object)n);
                collection.add(Integer.valueOf(n));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List funcIndices = list;
        WasmElement.Mode mode = element.getMode();
        if (Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Passive.INSTANCE)) {
            this.b.writeByte(isFuncIndices ? (byte)1 : 5);
            WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        } else if (mode instanceof WasmElement.Mode.Active) {
            Integer n = ((WasmElement.Mode.Active)mode).getTable().getId();
            Intrinsics.checkNotNull((Object)n);
            int tableId = n;
            if (tableId == 0 && isFuncIndices) {
                this.b.writeByte((byte)0);
                this.appendExpr((Iterable<? extends WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
            } else if (isFuncIndices) {
                this.b.writeByte((byte)2);
                this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                this.appendExpr((Iterable<? extends WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            } else {
                this.b.writeByte((byte)6);
                this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                this.appendExpr((Iterable<? extends WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            }
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        } else if (Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Declarative.INSTANCE)) {
            this.b.writeByte(isFuncIndices ? (byte)3 : 7);
            WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void appendCode(WasmFunction.Defined function2) {
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)() -> WasmIrToBinary.appendCode$lambda$57(this, function2)));
    }

    private final void appendData(WasmData wasmData) {
        WasmDataMode mode = wasmData.getMode();
        if (mode instanceof WasmDataMode.Active) {
            if (((WasmDataMode.Active)mode).getMemoryIdx() == 0) {
                this.b.writeByte((byte)0);
            } else {
                this.b.writeByte((byte)2);
                this.writeVarUInt32(this.b, ((WasmDataMode.Active)mode).getMemoryIdx());
            }
            this.appendExpr((Iterable<? extends WasmInstr>)((WasmDataMode.Active)mode).getOffset());
        } else if (Intrinsics.areEqual((Object)mode, (Object)WasmDataMode.Passive.INSTANCE)) {
            this.b.writeByte((byte)1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.writeVarUInt32(this.b, wasmData.getBytes().length);
        this.b.writeBytes(wasmData.getBytes());
    }

    public final void appendHeapType(@NotNull WasmHeapType type2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        WasmHeapType wasmHeapType = type2;
        if (wasmHeapType instanceof WasmHeapType.Simple) {
            n = ((WasmHeapType.Simple)type2).getCode();
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            Integer n2 = ((WasmHeapType.Type)type2).getType().getOwner().getId();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int code = n;
        this.b.writeVarInt32(code);
    }

    public final void appendType(@NotNull WasmType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.b.writeVarInt7(type2.getCode());
        if (type2 instanceof WasmRefType) {
            this.appendHeapType(((WasmRefType)type2).getHeapType());
        }
        if (type2 instanceof WasmRefNullType) {
            this.appendHeapType(((WasmRefNullType)type2).getHeapType());
        }
    }

    public final void appendLocalReference(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this.writeVarUInt32(this.b, local.getId());
    }

    public final void appendModuleFieldReference(@NotNull WasmNamedModuleField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer n = field.getId();
        if (n == null) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(field.getClass()) + ' ' + field.getName() + " ID is unlinked").toString());
        }
        int id = n;
        this.writeVarUInt32(this.b, id);
    }

    public final void writeVarUInt32(@NotNull ByteWriter $this$writeVarUInt32, int v) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarUInt32, (String)"<this>");
        $this$writeVarUInt32.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)v));
    }

    private final void writeString(ByteWriter $this$writeString, String str) {
        String string2 = str;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        this.writeVarUInt32($this$writeString, bytes.length);
        $this$writeString.writeBytes(bytes);
    }

    private static final Unit consumeDebugInformation$lambda$1$lambda$0(WasmIrToBinary this$0, DebugSection $it) {
        this$0.writeString(this$0.b, $it.getName());
        if (!($it.getData() instanceof DebugData.StringData)) {
            throw new NoWhenBranchMatchedException();
        }
        this$0.writeString(this$0.b, ((DebugData.StringData)$it.getData()).unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$4(WasmModule $this_with, WasmIrToBinary this$0) {
        WasmTypeDeclaration it;
        int numRecGroups = $this_with.getRecGroupTypes().isEmpty() ? 0 : 1;
        this$0.appendVectorSize($this_with.getFunctionTypes().size() + numRecGroups);
        Iterable $this$forEach$iv = $this_with.getFunctionTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmFunctionType)element$iv;
            boolean bl = false;
            this$0.appendFunctionTypeDeclaration((WasmFunctionType)it);
        }
        if (!((Collection)$this_with.getRecGroupTypes()).isEmpty()) {
            this$0.b.writeVarInt7((byte)-50);
            this$0.appendVectorSize($this_with.getRecGroupTypes().size());
            $this$forEach$iv = $this_with.getRecGroupTypes();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (WasmTypeDeclaration)element$iv;
                boolean bl = false;
                WasmTypeDeclaration wasmTypeDeclaration = it;
                if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
                    this$0.appendStructTypeDeclaration((WasmStructDeclaration)it);
                    continue;
                }
                if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
                    this$0.appendArrayTypeDeclaration((WasmArrayDeclaration)it);
                    continue;
                }
                if (wasmTypeDeclaration instanceof WasmFunctionType) {
                    this$0.appendFunctionTypeDeclaration((WasmFunctionType)it);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$6(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getImportsInOrder().size());
        Iterable $this$forEach$iv = $this_with.getImportsInOrder();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmNamedModuleField it = (WasmNamedModuleField)element$iv;
            boolean bl = false;
            WasmNamedModuleField wasmNamedModuleField = it;
            if (wasmNamedModuleField instanceof WasmFunction.Imported) {
                this$0.appendImportedFunction((WasmFunction.Imported)it);
                continue;
            }
            if (wasmNamedModuleField instanceof WasmMemory) {
                this$0.appendMemory((WasmMemory)it);
                continue;
            }
            if (wasmNamedModuleField instanceof WasmTable) {
                this$0.appendTable((WasmTable)it);
                continue;
            }
            if (wasmNamedModuleField instanceof WasmGlobal) {
                this$0.appendGlobal((WasmGlobal)it);
                continue;
            }
            if (wasmNamedModuleField instanceof WasmTag) {
                this$0.appendTag((WasmTag)it);
                continue;
            }
            throw new IllegalStateException(("Unknown import kind " + Reflection.getOrCreateKotlinClass(it.getClass())).toString());
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$8(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getDefinedFunctions().size());
        Iterable $this$forEach$iv = $this_with.getDefinedFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
            boolean bl = false;
            this$0.appendDefinedFunction(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$10(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getTables().size());
        Iterable $this$forEach$iv = $this_with.getTables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmTable it = (WasmTable)element$iv;
            boolean bl = false;
            this$0.appendTable(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$12(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getMemories().size());
        Iterable $this$forEach$iv = $this_with.getMemories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmMemory it = (WasmMemory)element$iv;
            boolean bl = false;
            this$0.appendMemory(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$14(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getTags().size());
        Iterable $this$forEach$iv = $this_with.getTags();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmTag it = (WasmTag)element$iv;
            boolean bl = false;
            this$0.appendTag(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$16(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getGlobals().size());
        Iterable $this$forEach$iv = $this_with.getGlobals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmGlobal it = (WasmGlobal)element$iv;
            boolean bl = false;
            this$0.appendGlobal(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$18(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getExports().size());
        Iterable $this$forEach$iv = $this_with.getExports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmExport it = (WasmExport)element$iv;
            boolean bl = false;
            this$0.appendExport(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$19(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendStartFunction($this_with.getStartFunction());
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$21(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getElements().size());
        Iterable $this$forEach$iv = $this_with.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmElement it = (WasmElement)element$iv;
            boolean bl = false;
            this$0.appendElement(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$22(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.b.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)$this_with.getData().size()));
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$24(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getDefinedFunctions().size());
        Iterable $this$forEach$iv = $this_with.getDefinedFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
            boolean bl = false;
            this$0.appendCode(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendWasmModule$lambda$28$lambda$26(WasmIrToBinary this$0, WasmModule $this_with) {
        this$0.appendVectorSize($this_with.getData().size());
        Iterable $this$forEach$iv = $this_with.getData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmData it = (WasmData)element$iv;
            boolean bl = false;
            this$0.appendData(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42$lambda$29(WasmIrToBinary this$0) {
        this$0.writeString(this$0.b, this$0.moduleName);
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42$lambda$31(WasmIrToBinary this$0, List $definedFunctions) {
        this$0.appendVectorSize($definedFunctions.size());
        Iterable $this$forEach$iv = $definedFunctions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
            boolean bl = false;
            this$0.appendModuleFieldReference(it);
            this$0.writeString(this$0.b, it.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42$lambda$34(WasmIrToBinary this$0, List $definedFunctions) {
        this$0.appendVectorSize($definedFunctions.size());
        Iterable $this$forEach$iv = $definedFunctions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
            boolean bl = false;
            this$0.appendModuleFieldReference(it);
            this$0.appendVectorSize(it.getLocals().size());
            Iterable $this$forEach$iv2 = it.getLocals();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WasmLocal local = (WasmLocal)element$iv2;
                boolean bl2 = false;
                this$0.writeVarUInt32(this$0.b, local.getId());
                this$0.writeString(this$0.b, local.getName());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42$lambda$36(WasmIrToBinary this$0) {
        this$0.appendVectorSize(this$0.module.getRecGroupTypes().size());
        Iterable $this$forEach$iv = this$0.module.getRecGroupTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmTypeDeclaration it = (WasmTypeDeclaration)element$iv;
            boolean bl = false;
            this$0.appendModuleFieldReference(it);
            this$0.writeString(this$0.b, it.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42$lambda$38(WasmIrToBinary this$0) {
        this$0.appendVectorSize(this$0.module.getGlobals().size());
        Iterable $this$forEach$iv = this$0.module.getGlobals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmGlobal global = (WasmGlobal)element$iv;
            boolean bl = false;
            this$0.appendModuleFieldReference(global);
            this$0.writeString(this$0.b, global.getName());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit appendTextSection$lambda$42$lambda$41(WasmIrToBinary this$0) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this$0.module.getRecGroupTypes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WasmStructDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List structDeclarations = (List)destination$iv$iv;
        this$0.appendVectorSize(structDeclarations.size());
        Iterable $this$forEach$iv = structDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmStructDeclaration it = (WasmStructDeclaration)element$iv;
            boolean bl = false;
            this$0.appendModuleFieldReference(it);
            this$0.appendVectorSize(it.getFields().size());
            Iterable $this$forEachIndexed$iv = it.getFields();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void field;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WasmStructFieldDeclaration wasmStructFieldDeclaration = (WasmStructFieldDeclaration)item$iv;
                int index = n;
                boolean bl2 = false;
                this$0.writeVarUInt32(this$0.b, index);
                this$0.writeString(this$0.b, field.getName());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendTextSection$lambda$42(WasmIrToBinary this$0, List $definedFunctions) {
        this$0.writeString(this$0.b, "name");
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getCUSTOM-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$29(this$0)));
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getTYPE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$31(this$0, $definedFunctions)));
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getIMPORT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$34(this$0, $definedFunctions)));
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getTABLE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$36(this$0)));
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getEXPORT-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$38(this$0)));
        this$0.appendSection-Sr9dMcE(WasmBinary.Section.Companion.getCODE-Esw0DI4(), (Function0<Unit>)((Function0)() -> WasmIrToBinary.appendTextSection$lambda$42$lambda$41(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit appendSection_Sr9dMcE$lambda$45(Function0 $content) {
        $content.invoke();
        return Unit.INSTANCE;
    }

    private static final void appendElement$writeElements(WasmIrToBinary this$0, WasmElement $element, List<Integer> funcIndices) {
        this$0.appendVectorSize($element.getValues().size());
        if (funcIndices != null) {
            Iterable $this$forEach$iv = funcIndices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                this$0.writeVarUInt32(this$0.b, it);
            }
        } else {
            Iterable $this$forEach$iv = $element.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmTable.Value it = (WasmTable.Value)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmTable.Value.Expression");
                this$0.appendExpr((Iterable<? extends WasmInstr>)((WasmTable.Value.Expression)it).getExpr());
            }
        }
    }

    private static final void appendElement$writeTypeOrKind(boolean isFuncIndices, WasmIrToBinary this$0, WasmElement $element) {
        if (isFuncIndices) {
            this$0.b.writeByte((byte)0);
        } else {
            this$0.appendType($element.getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit appendCode$lambda$57(WasmIrToBinary this$0, WasmFunction.Defined $function) {
        int n;
        void $this$count$iv;
        Iterable iterable = $function.getLocals();
        ByteWriter byteWriter = this$0.b;
        WasmIrToBinary wasmIrToBinary = this$0;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                WasmLocal it = (WasmLocal)element$iv;
                boolean bl = false;
                if (!(!it.isParameter()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        wasmIrToBinary.writeVarUInt32(byteWriter, n2);
        Iterable $this$forEach$iv = $function.getLocals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmLocal local = (WasmLocal)element$iv;
            boolean bl = false;
            if (local.isParameter()) continue;
            this$0.b.writeVarUInt32-WZ4Q5Ns(1);
            this$0.appendType(local.getType());
        }
        this$0.appendExpr((Iterable<? extends WasmInstr>)$function.getInstructions());
        return Unit.INSTANCE;
    }
}

